/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.twitter;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.lamsfoundation.lams.contentrepository.ItemNotFoundException;
import org.lamsfoundation.lams.contentrepository.RepositoryCheckedException;
import org.lamsfoundation.lams.contentrepository.client.IToolContentHandler;
import org.lamsfoundation.lams.tool.twitter.TwitterAttachment;

public class TwitterContent
implements Serializable {
    private Long uid;
    private Long twitterContentId;
    private String title;
    private String content;
    private String onlineInstructions;
    private String offlineInstructions;
    private String teacherTwitterUsername;
    private String learnersTwitterUsernames;
    private String hashtags;
    private int tweetNumber;
    private boolean defineLater;
    private boolean forceOffline;
    private Boolean reflectOnActivity;
    private String reflectInstructions;
    private boolean contentInUse;
    private Long creatorUserId;
    private Date dateCreated;
    private Date dateUpdated;
    private String activityHashtag = "";
    private Set twitterSessions = new HashSet();
    private Set twitterAttachments = new HashSet();

    public TwitterContent() {
    }

    public TwitterContent(Long uid) {
        this.uid = uid;
    }

    public TwitterContent(Long twitterContentId, String title, String content, String onlineInstructions, String offlineInstructions, String teacherTwitterUsername, String learnersTwitterUsernames, String hashtags, int tweetNumber, boolean defineLater, boolean forceOffline, boolean reflectOnActivity, String reflectInstructions, boolean contentInUse, Long creatorUserId, Date dateCreated, Date dateUpdated) {
        this.twitterContentId = twitterContentId;
        this.title = title;
        this.content = content;
        this.onlineInstructions = onlineInstructions;
        this.offlineInstructions = offlineInstructions;
        this.teacherTwitterUsername = teacherTwitterUsername;
        this.learnersTwitterUsernames = learnersTwitterUsernames;
        this.hashtags = hashtags;
        this.tweetNumber = tweetNumber;
        this.defineLater = defineLater;
        this.forceOffline = forceOffline;
        this.reflectOnActivity = reflectOnActivity;
        this.reflectInstructions = reflectInstructions;
        this.contentInUse = contentInUse;
        this.creatorUserId = creatorUserId;
        this.dateCreated = dateCreated;
        this.dateUpdated = dateUpdated;
    }

    public TwitterContent(Long twitterContentId, String title, String content, String onlineInstructions, String offlineInstructions, String teacherTwitterUsername, String learnersTwitterUsernames, String hashtags, int tweetNumber, Date dateCreated) {
        this.twitterContentId = twitterContentId;
        this.title = title;
        this.content = content;
        this.onlineInstructions = onlineInstructions;
        this.offlineInstructions = offlineInstructions;
        this.teacherTwitterUsername = teacherTwitterUsername;
        this.learnersTwitterUsernames = learnersTwitterUsernames;
        this.hashtags = hashtags;
        this.tweetNumber = tweetNumber;
        this.defineLater = false;
        this.forceOffline = false;
        this.reflectOnActivity = false;
        this.contentInUse = false;
        this.creatorUserId = null;
        this.dateCreated = dateCreated;
        this.dateUpdated = null;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Long getCreatorUserId() {
        return this.creatorUserId;
    }

    public void setCreatorUserId(Long creatorUserId) {
        this.creatorUserId = creatorUserId;
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public Date getDateUpdated() {
        return this.dateUpdated;
    }

    public void setDateUpdated(Date dateUpdated) {
        this.dateUpdated = dateUpdated;
    }

    public boolean isDefineLater() {
        return this.defineLater;
    }

    public void setDefineLater(boolean defineLater) {
        this.defineLater = defineLater;
    }

    public boolean isForceOffline() {
        return this.forceOffline;
    }

    public void setForceOffline(boolean forceOffline) {
        this.forceOffline = forceOffline;
    }

    public boolean getReflectOnActivity() {
        return this.reflectOnActivity;
    }

    public void setReflectOnActivity(boolean reflectOnActivity) {
        this.reflectOnActivity = reflectOnActivity;
    }

    public String getReflectInstructions() {
        return this.reflectInstructions;
    }

    public void setReflectInstructions(String reflectInstructions) {
        this.reflectInstructions = reflectInstructions;
    }

    public boolean isContentInUse() {
        return this.contentInUse;
    }

    public void setContentInUse(boolean contentInUse) {
        this.contentInUse = contentInUse;
    }

    public Long getTwitterContentId() {
        return this.twitterContentId;
    }

    public void setTwitterContentId(Long twitterContentId) {
        this.twitterContentId = twitterContentId;
    }

    public Set getTwitterSessions() {
        if (this.twitterSessions == null) {
            this.setTwitterSessions(new HashSet());
        }
        return this.twitterSessions;
    }

    public void setTwitterSessions(Set twitterSessions) {
        this.twitterSessions = twitterSessions;
    }

    public Set getTwitterAttachments() {
        return this.twitterAttachments;
    }

    public void setTwitterAttachments(Set twitterAttachments) {
        this.twitterAttachments = twitterAttachments;
    }

    public String getOfflineInstructions() {
        return this.offlineInstructions;
    }

    public void setOfflineInstructions(String offlineInstructions) {
        this.offlineInstructions = offlineInstructions;
    }

    public String getTeacherTwitterUsername() {
        return this.teacherTwitterUsername;
    }

    public void setTeacherTwitterUsername(String teacherTwitterUsername) {
        this.teacherTwitterUsername = teacherTwitterUsername;
    }

    public String getLearnersTwitterUsernames() {
        return this.learnersTwitterUsernames;
    }

    public void setLearnersTwitterUsernames(String learnersTwitterUsernames) {
        this.learnersTwitterUsernames = learnersTwitterUsernames;
    }

    public String getHashtags() {
        return this.hashtags;
    }

    public void setHashtags(String hashtags) {
        this.hashtags = hashtags;
    }

    public int getTweetNumber() {
        return this.tweetNumber;
    }

    public void setTweetNumber(int tweetNumber) {
        this.tweetNumber = tweetNumber;
    }

    public String getActivityHashtag() {
        return this.activityHashtag;
    }

    public void setActivityHashtag(String activityHashtag) {
        this.activityHashtag = activityHashtag;
    }

    public String getOnlineInstructions() {
        return this.onlineInstructions;
    }

    public void setOnlineInstructions(String onlineInstructions) {
        this.onlineInstructions = onlineInstructions;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Long getUid() {
        return this.uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public static TwitterContent newInstance(TwitterContent twitter, Long toContentId, IToolContentHandler toolContentHandler) throws ItemNotFoundException, RepositoryCheckedException {
        TwitterContent newContent = new TwitterContent(toContentId, twitter.getTitle(), twitter.getContent(), twitter.getOnlineInstructions(), twitter.getOfflineInstructions(), twitter.getTeacherTwitterUsername(), twitter.getLearnersTwitterUsernames(), twitter.getHashtags(), twitter.getTweetNumber(), twitter.isDefineLater(), twitter.isForceOffline(), twitter.getReflectOnActivity(), twitter.getReflectInstructions(), twitter.isContentInUse(), twitter.getCreatorUserId(), twitter.getDateCreated(), twitter.getDateUpdated());
        if (twitter.getTwitterAttachments() != null && twitter.getTwitterAttachments().size() > 0) {
            HashSet<TwitterAttachment> newAttachmentSet = new HashSet<TwitterAttachment>();
            for (TwitterAttachment element : twitter.getTwitterAttachments()) {
                TwitterAttachment newAttachment = new TwitterAttachment(newContent, element.getFilename(), element.isOnlineFile());
                newAttachment.setUuid(element.getUuid());
                newAttachment.setVersionId(element.getVersionId());
                newAttachmentSet.add(newAttachment);
            }
            newContent.setTwitterAttachments(newAttachmentSet);
        }
        return newContent;
    }
}

