/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.twitter.dao.hibernate;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.lamsfoundation.lams.tool.twitter.TwitterContent;
import org.lamsfoundation.lams.tool.twitter.TwitterSession;
import org.lamsfoundation.lams.tool.twitter.dao.ITwitterContentDAO;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class TwitterContentDAO
extends HibernateDaoSupport
implements ITwitterContentDAO {
    private static final String FIND_NB_CONTENT = "from " + TwitterContent.class.getName() + " as twitter where twitter.twitterContentId=?";
    private static final String LOAD_NB_BY_SESSION = "select twitter from TwitterContent twitter left join fetch twitter.twitterSessions session where session.twitterSessionId=:sessionId";

    @Override
    public TwitterContent getTwitterContentByUID(Long uid) {
        return (TwitterContent)this.getHibernateTemplate().get(TwitterContent.class, (Serializable)uid);
    }

    @Override
    public TwitterContent findTwitterContentById(Long twitterContentId) {
        String query = "from TwitterContent as twitter where twitter.twitterContentId = ?";
        List content = this.getHibernateTemplate().find(query, (Object)twitterContentId);
        if (content != null && content.size() == 0) {
            return null;
        }
        return (TwitterContent)content.get(0);
    }

    @Override
    public TwitterContent getTwitterContentBySession(final Long twitterSessionId) {
        return (TwitterContent)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createQuery(TwitterContentDAO.LOAD_NB_BY_SESSION).setLong("sessionId", twitterSessionId.longValue()).uniqueResult();
            }
        });
    }

    @Override
    public void saveTwitterContent(TwitterContent twitterContent) {
        this.getHibernateTemplate().save((Object)twitterContent);
    }

    @Override
    public void updateTwitterContent(TwitterContent twitterContent) {
        this.getHibernateTemplate().update((Object)twitterContent);
    }

    @Override
    public void removeTwitter(Long twitterContentId) {
        List list;
        if (twitterContentId != null && (list = this.getSession().createQuery(FIND_NB_CONTENT).setLong(0, twitterContentId.longValue()).list()) != null && list.size() > 0) {
            TwitterContent twitter = (TwitterContent)list.get(0);
            this.getSession().setFlushMode(FlushMode.AUTO);
            this.getHibernateTemplate().delete((Object)twitter);
            this.getHibernateTemplate().flush();
        }
    }

    @Override
    public void removeTwitter(TwitterContent twitterContent) {
        this.removeTwitter(twitterContent.getTwitterContentId());
    }

    @Override
    public void removeTwitterSessions(TwitterContent twitterContent) {
        this.getHibernateTemplate().deleteAll((Collection)twitterContent.getTwitterSessions());
    }

    @Override
    public void addTwitterSession(Long twitterContentId, TwitterSession twitterSession) {
        TwitterContent content = this.findTwitterContentById(twitterContentId);
        twitterSession.setTwitterContent(content);
        content.getTwitterSessions().add(twitterSession);
        this.getHibernateTemplate().saveOrUpdate((Object)twitterSession);
        this.getHibernateTemplate().saveOrUpdate((Object)content);
    }
}

