/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.twitter.web;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.tool.twitter.TwitterApplicationException;
import org.lamsfoundation.lams.tool.twitter.TwitterContent;
import org.lamsfoundation.lams.tool.twitter.TwitterSession;
import org.lamsfoundation.lams.tool.twitter.TwitterUser;
import org.lamsfoundation.lams.tool.twitter.dto.ReflectionDTO;
import org.lamsfoundation.lams.tool.twitter.service.ITwitterService;
import org.lamsfoundation.lams.tool.twitter.service.TwitterServiceProxy;
import org.lamsfoundation.lams.tool.twitter.util.TwitterWebUtil;
import org.lamsfoundation.lams.tool.twitter.web.TwitterExportForm;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;

public class TwitterExportAction
extends LamsDispatchAction {
    static Logger logger = Logger.getLogger((String)TwitterExportForm.class.getName());

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("exportPortfolio");
    }

    public ActionForward learner(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        TwitterExportForm exportForm = (TwitterExportForm)form;
        Long toolSessionId = TwitterWebUtil.convertToLong(request.getParameter("toolSessionID"));
        Long userId = TwitterWebUtil.convertToLong(request.getParameter("userID"));
        ITwitterService twitterService = TwitterServiceProxy.getTwitterService(this.getServlet().getServletContext());
        if (userId == null || toolSessionId == null) {
            String error = "Tool session Id or user Id is null. Unable to continue";
            logger.error((Object)error);
            throw new TwitterApplicationException(error);
        }
        TwitterUser userInThisSession = twitterService.retrieveTwitterUserBySession(userId, toolSessionId);
        if (userInThisSession == null) {
            String error = "The user with user id " + userId + " does not exist in this session or session may not exist.";
            logger.error((Object)error);
            throw new TwitterApplicationException(error);
        }
        TwitterContent content = twitterService.retrieveTwitterBySessionID(toolSessionId);
        if (content == null) {
            String error = "The content for this activity has not been defined yet.";
            logger.error((Object)error);
            throw new TwitterApplicationException(error);
        }
        if (content.getReflectOnActivity()) {
            log.debug((Object)content.getReflectOnActivity());
            request.setAttribute("learner", (Object)true);
            NotebookEntry twitterEntry = twitterService.getEntry(userInThisSession.getTwitterSession().getTwitterSessionId(), CoreNotebookConstants.NOTEBOOK_TOOL, "fptwit10", userId.intValue());
            log.debug((Object)twitterEntry);
            if (twitterEntry != null) {
                request.setAttribute("twitterEntry", (Object)twitterEntry.getEntry());
            }
        }
        exportForm.populateForm(content);
        return mapping.findForward("exportPortfolio");
    }

    public ActionForward teacher(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        TwitterExportForm exportForm = (TwitterExportForm)form;
        ITwitterService twitterService = TwitterServiceProxy.getTwitterService(this.getServlet().getServletContext());
        Long toolContentId = TwitterWebUtil.convertToLong(request.getParameter("toolContentID"));
        if (toolContentId == null) {
            String error = "Tool Content Id is missing. Unable to continue";
            logger.error((Object)error);
            throw new TwitterApplicationException(error);
        }
        TwitterContent content = twitterService.retrieveTwitter(toolContentId);
        if (content == null) {
            String error = "Data is missing from the database. Unable to Continue";
            logger.error((Object)error);
            throw new TwitterApplicationException(error);
        }
        if (content.getReflectOnActivity()) {
            Set sessions = content.getTwitterSessions();
            Iterator i = sessions.iterator();
            ArrayList<ReflectionDTO> reflections = new ArrayList<ReflectionDTO>();
            while (i.hasNext()) {
                TwitterSession session = (TwitterSession)i.next();
                List sessionUsers = twitterService.getUsersBySession(session.getTwitterSessionId());
                for (int j = 0; j < sessionUsers.size(); ++j) {
                    TwitterUser twitterUser = (TwitterUser)sessionUsers.get(j);
                    NotebookEntry twitterEntry = twitterService.getEntry(twitterUser.getTwitterSession().getTwitterSessionId(), CoreNotebookConstants.NOTEBOOK_TOOL, "fptwit10", twitterUser.getUserId().intValue());
                    log.debug((Object)twitterEntry);
                    if (twitterEntry == null) continue;
                    ReflectionDTO dto = new ReflectionDTO(twitterEntry);
                    dto.setFullName(twitterUser.getFullname());
                    reflections.add(dto);
                }
            }
            request.setAttribute("reflections", reflections);
        }
        exportForm.populateForm(content);
        return mapping.findForward("exportPortfolio");
    }
}

