/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.twitter.dao.hibernate;

import java.io.Serializable;
import java.util.List;
import org.hibernate.FlushMode;
import org.lamsfoundation.lams.tool.twitter.TwitterAttachment;
import org.lamsfoundation.lams.tool.twitter.TwitterContent;
import org.lamsfoundation.lams.tool.twitter.dao.ITwitterAttachmentDAO;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class TwitterAttachmentDAO
extends HibernateDaoSupport
implements ITwitterAttachmentDAO {
    private static final String FIND_NB_ATTACHMENT_BY_UUID = "from " + TwitterAttachment.class.getName() + " as twitter where twitter.uuid=?";
    private static final String FIND_NB_ATTACHMENT_BY_FILENAME = "from " + TwitterAttachment.class.getName() + " as twitter where twitter.filename=?";
    private static final String GET_ATTACHMENT_FROM_CONTENT = "select twitter.attachmentId from " + TwitterAttachment.class.getName() + " as twitter where twitter.twitterContent= :twitterContent";

    @Override
    public TwitterAttachment retrieveAttachment(Long attachmentId) {
        return (TwitterAttachment)this.getHibernateTemplate().get(TwitterAttachment.class, (Serializable)attachmentId);
    }

    @Override
    public TwitterAttachment retrieveAttachmentByUuid(Long uuid) {
        List attachments = this.getSession().createQuery(FIND_NB_ATTACHMENT_BY_UUID).setLong(0, uuid.longValue()).list();
        if (attachments != null && attachments.size() > 0) {
            TwitterAttachment twitter = (TwitterAttachment)attachments.get(0);
            return twitter;
        }
        return null;
    }

    @Override
    public TwitterAttachment retrieveAttachmentByFilename(String filename) {
        List attachments = this.getSession().createQuery(FIND_NB_ATTACHMENT_BY_FILENAME).setString(0, filename).list();
        if (attachments != null && attachments.size() > 0) {
            TwitterAttachment twitter = (TwitterAttachment)attachments.get(0);
            return twitter;
        }
        return null;
    }

    @Override
    public List getAttachmentIdsFromContent(TwitterContent twitterContent) {
        return this.getHibernateTemplate().findByNamedParam(GET_ATTACHMENT_FROM_CONTENT, "twitterContent", (Object)twitterContent);
    }

    @Override
    public void saveAttachment(TwitterAttachment attachment) {
        this.getHibernateTemplate().saveOrUpdate((Object)attachment);
    }

    @Override
    public void removeAttachment(TwitterAttachment attachment) {
        this.removeAttachment(attachment.getUuid());
    }

    @Override
    public void removeAttachment(Long uuid) {
        List attachments = this.getSession().createQuery(FIND_NB_ATTACHMENT_BY_UUID).setLong(0, uuid.longValue()).list();
        if (attachments != null && attachments.size() > 0) {
            TwitterAttachment twitter = (TwitterAttachment)attachments.get(0);
            this.getSession().setFlushMode(FlushMode.AUTO);
            this.getHibernateTemplate().delete((Object)twitter);
            this.getHibernateTemplate().flush();
        }
    }
}

