/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.twitter.dao.hibernate;

import java.util.Collection;
import java.util.List;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.lamsfoundation.lams.tool.twitter.TwitterContent;
import org.lamsfoundation.lams.tool.twitter.TwitterSession;
import org.lamsfoundation.lams.tool.twitter.TwitterUser;
import org.lamsfoundation.lams.tool.twitter.dao.ITwitterSessionDAO;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class TwitterSessionDAO
extends HibernateDaoSupport
implements ITwitterSessionDAO {
    private static final String FIND_NB_SESSION = "from " + TwitterSession.class.getName() + " as twitter where twitter.twitterSessionId=?";
    private static final String LOAD_NBSESSION_BY_USER = "select ns from TwitterSession ns left join fetch ns.twitterUsers user where user.userId=:userId";
    private static final String GET_SESSIONS_FROM_CONTENT = "select ns.twitterSessionId from TwitterSession ns where ns.twitterContent= :twitterContent";

    @Override
    public TwitterSession findTwitterSessionById(Long twitterSessionId) {
        String query = "from TwitterSession twitterS where twitterS.twitterSessionId=?";
        List session = this.getHibernateTemplate().find(query, (Object)twitterSessionId);
        if (session != null && session.size() == 0) {
            return null;
        }
        return (TwitterSession)session.get(0);
    }

    @Override
    public void saveTwitterSession(TwitterSession twitterSession) {
        this.getHibernateTemplate().save((Object)twitterSession);
    }

    @Override
    public void updateTwitterSession(TwitterSession twitterSession) {
        this.getHibernateTemplate().update((Object)twitterSession);
    }

    @Override
    public void removeTwitterSession(Long twitterSessionId) {
        List list;
        HibernateTemplate templ = this.getHibernateTemplate();
        if (twitterSessionId != null && (list = this.getSession().createQuery(FIND_NB_SESSION).setLong(0, twitterSessionId.longValue()).list()) != null && list.size() > 0) {
            TwitterSession twitter = (TwitterSession)list.get(0);
            this.getSession().setFlushMode(FlushMode.AUTO);
            templ.delete((Object)twitter);
            templ.flush();
        }
    }

    @Override
    public void removeTwitterSession(TwitterSession twitterSession) {
        this.removeTwitterSession(twitterSession.getTwitterSessionId());
    }

    @Override
    public TwitterSession getTwitterSessionByUser(final Long userId) {
        return (TwitterSession)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createQuery(TwitterSessionDAO.LOAD_NBSESSION_BY_USER).setLong("userId", userId.longValue()).uniqueResult();
            }
        });
    }

    @Override
    public void removeTwitterUsers(TwitterSession twitterSession) {
        this.getHibernateTemplate().deleteAll((Collection)twitterSession.getTwitterUsers());
    }

    @Override
    public void addTwitterUsers(Long twitterSessionId, TwitterUser user) {
        TwitterSession session = this.findTwitterSessionById(twitterSessionId);
        user.setTwitterSession(session);
        session.getTwitterUsers().add(user);
        this.getHibernateTemplate().saveOrUpdate((Object)user);
        this.getHibernateTemplate().merge((Object)session);
    }

    @Override
    public List getSessionsFromContent(TwitterContent twitterContent) {
        return this.getHibernateTemplate().findByNamedParam(GET_SESSIONS_FROM_CONTENT, "twitterContent", (Object)twitterContent);
    }
}

