/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.twitter.dao.hibernate;

import java.util.List;
import org.hibernate.FlushMode;
import org.lamsfoundation.lams.tool.twitter.TwitterSession;
import org.lamsfoundation.lams.tool.twitter.TwitterUser;
import org.lamsfoundation.lams.tool.twitter.dao.ITwitterUserDAO;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class TwitterUserDAO
extends HibernateDaoSupport
implements ITwitterUserDAO {
    private static final String FIND_NB_USER = "from " + TwitterUser.class.getName() + " as twitter where twitter.userId=?";
    private static final String FIND_NB_USER_BY_SESSION = "from " + TwitterUser.class.getName() + " as twitter where twitter.userId=? and twitter.twitterSession.twitterSessionId=?";
    private static final String COUNT_USERS_IN_SESSION = "select nu.userId from TwitterUser nu where nu.twitterSession= :twitterSession";

    @Override
    public TwitterUser getTwitterUser(Long userId, Long sessionId) {
        String query = "from TwitterUser user where user.userId=? and user.twitterSession.twitterSessionId=?";
        Object[] values = new Object[]{userId, sessionId};
        List users = this.getHibernateTemplate().find(query, values);
        if (users != null && users.size() == 0) {
            return null;
        }
        return (TwitterUser)users.get(0);
    }

    @Override
    public TwitterUser getTwitterUserBySession(Long userId, Long sessionId) {
        List usersReturned = this.getSession().createQuery(FIND_NB_USER_BY_SESSION).setLong(0, userId.longValue()).setLong(1, sessionId.longValue()).list();
        if (usersReturned != null && usersReturned.size() > 0) {
            TwitterUser twitter = (TwitterUser)usersReturned.get(0);
            return twitter;
        }
        return null;
    }

    @Override
    public void saveTwitterUser(TwitterUser twitterUser) {
        this.getHibernateTemplate().save((Object)twitterUser);
    }

    @Override
    public void updateTwitterUser(TwitterUser twitterUser) {
        this.getHibernateTemplate().update((Object)twitterUser);
    }

    @Override
    public void removeTwitterUser(Long userId) {
        List list;
        if (userId != null && (list = this.getSession().createQuery(FIND_NB_USER).setLong(0, userId.longValue()).list()) != null && list.size() > 0) {
            TwitterUser twitter = (TwitterUser)list.get(0);
            this.getSession().setFlushMode(FlushMode.AUTO);
            this.getHibernateTemplate().delete((Object)twitter);
            this.getHibernateTemplate().flush();
        }
    }

    @Override
    public void removeTwitterUser(TwitterUser twitterUser) {
        this.removeTwitterUser(twitterUser.getUserId());
    }

    @Override
    public int getNumberOfUsers(TwitterSession twitterSession) {
        return this.getHibernateTemplate().findByNamedParam(COUNT_USERS_IN_SESSION, "twitterSession", (Object)twitterSession).size();
    }

    @Override
    public List getTwitterUsersBySession(Long sessionId) {
        String query = "from TwitterUser user where user.twitterSession.twitterSessionId=?";
        return this.getHibernateTemplate().find(query, (Object)sessionId);
    }
}

