/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.twitter.web;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.upload.FormFile;
import org.apache.struts.util.MessageResources;
import org.lamsfoundation.lams.contentrepository.InvalidParameterException;
import org.lamsfoundation.lams.contentrepository.NodeKey;
import org.lamsfoundation.lams.contentrepository.RepositoryCheckedException;
import org.lamsfoundation.lams.tool.twitter.TwitterApplicationException;
import org.lamsfoundation.lams.tool.twitter.TwitterAttachment;
import org.lamsfoundation.lams.tool.twitter.TwitterContent;
import org.lamsfoundation.lams.tool.twitter.service.ITwitterService;
import org.lamsfoundation.lams.tool.twitter.service.TwitterServiceProxy;
import org.lamsfoundation.lams.tool.twitter.util.TwitterWebUtil;
import org.lamsfoundation.lams.tool.twitter.web.TwitterAuthoringForm;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.FileValidatorUtil;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.lamsfoundation.lams.web.util.SessionMap;

public class TwitterAuthoringAction
extends LamsDispatchAction {
    static Logger logger = Logger.getLogger((String)TwitterAuthoringAction.class.getName());
    public static final String FORM = "TwitterAuthoringForm";

    public UserDTO getUser(HttpServletRequest request) {
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        if (user == null) {
            MessageResources resources = this.getResources(request);
            String error = resources.getMessage("error.missingParam", (Object)"User");
            logger.error((Object)error);
            throw new TwitterApplicationException(error);
        }
        return user;
    }

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws TwitterApplicationException {
        TwitterAuthoringForm twitterForm = new TwitterAuthoringForm();
        Long contentId = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID");
        String contentFolderId = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        twitterForm.setToolContentID(contentId.toString());
        twitterForm.setDefineLater(request.getParameter("defineLater"));
        ITwitterService twitterService = TwitterServiceProxy.getTwitterService(this.getServlet().getServletContext());
        List attachmentList = null;
        if (!this.contentExists(twitterService, contentId)) {
            Long defaultToolContentId = twitterService.getToolDefaultContentIdBySignature("fptwit10");
            TwitterContent twitter = twitterService.retrieveTwitter(defaultToolContentId);
            if (twitter == null) {
                String error = "There is data missing in the database";
                logger.error((Object)error);
                throw new TwitterApplicationException(error);
            }
            twitterForm.setToolContentID(contentId.toString());
            twitterForm.setContentFolderID(contentFolderId);
            twitterForm.setTitle(twitter.getTitle());
            twitterForm.setContent(twitter.getContent());
            twitterForm.setOnlineInstructions(twitter.getOnlineInstructions());
            twitterForm.setOfflineInstructions(twitter.getOfflineInstructions());
            twitterForm.setTeacherTwitterUsername(twitter.getTeacherTwitterUsername());
            twitterForm.setLearnersTwitterUsernames(twitter.getLearnersTwitterUsernames());
            twitterForm.setHashtags(twitter.getHashtags());
            attachmentList = TwitterWebUtil.setupAttachmentList(twitterService, null);
        } else {
            TwitterContent twitter = twitterService.retrieveTwitter(contentId);
            twitterForm.populateFormWithTwitterContentValues(twitter);
            twitterForm.setContentFolderID(contentFolderId);
            twitter.setDefineLater(Boolean.parseBoolean(twitterForm.getDefineLater()));
            twitterService.saveTwitter(twitter);
            attachmentList = TwitterWebUtil.setupAttachmentList(twitterService, twitter);
        }
        SessionMap map = TwitterWebUtil.addUploadsToSession(null, request, attachmentList, TwitterWebUtil.setupDeletedAttachmentList());
        twitterForm.setSessionMapID(map.getSessionID());
        request.setAttribute(FORM, (Object)twitterForm);
        return mapping.findForward("authoringContent");
    }

    private boolean contentExists(ITwitterService service, Long id) {
        TwitterContent twitter = service.retrieveTwitter(id);
        return twitter != null;
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws TwitterApplicationException {
        TwitterAuthoringForm twitterForm = (TwitterAuthoringForm)form;
        ITwitterService twitterService = TwitterServiceProxy.getTwitterService(this.getServlet().getServletContext());
        String idAsString = twitterForm.getToolContentID();
        if (idAsString == null) {
            MessageResources resources = this.getResources(request);
            String error = resources.getMessage("error.missingParam", (Object)"Tool Content Id");
            logger.error((Object)error);
            throw new TwitterApplicationException(error);
        }
        Long content_id = TwitterWebUtil.convertToLong(twitterForm.getToolContentID());
        this.checkContentId(content_id);
        TwitterContent twitterContent = twitterService.retrieveTwitter(content_id);
        if (twitterContent == null) {
            twitterContent = new TwitterContent();
            twitterContent.setTwitterContentId(content_id);
        }
        twitterForm.copyValuesIntoTwitterContent(twitterContent);
        twitterContent.setTeacherTwitterUsername(twitterContent.getTeacherTwitterUsername().trim());
        twitterContent.setLearnersTwitterUsernames(this.parseTags(twitterContent.getLearnersTwitterUsernames()));
        twitterContent.setHashtags(this.parseTags(twitterContent.getHashtags()));
        twitterContent.setActivityHashtag("lams_" + TwitterAuthoringAction.getRandomString(6));
        System.out.println("lams_" + TwitterAuthoringAction.getRandomString(6) + "******");
        if (twitterContent.getDateCreated() == null) {
            twitterContent.setDateCreated(twitterContent.getDateUpdated());
        }
        UserDTO user = this.getUser(request);
        twitterContent.setCreatorUserId(new Long(user.getUserID().longValue()));
        twitterContent.setDefineLater(false);
        twitterService.saveTwitter(twitterContent);
        SessionMap sessionMap = this.getSessionMap(request, twitterForm);
        List attachmentList = (List)sessionMap.get((Object)"attachmentList");
        List deletedAttachmentList = (List)sessionMap.get((Object)"deletedAttachmentList");
        deletedAttachmentList = this.saveAttachments(twitterService, twitterContent, attachmentList, deletedAttachmentList, mapping, request);
        sessionMap = TwitterWebUtil.addUploadsToSession(sessionMap, request, attachmentList, deletedAttachmentList);
        request.setAttribute("LAMS_AUTHORING_SUCCESS_FLAG", (Object)Boolean.TRUE);
        return mapping.findForward("authoringContent");
    }

    private List saveAttachments(ITwitterService twitterService, TwitterContent twitterContent, List attachmentList, List deletedAttachmentList, ActionMapping mapping, HttpServletRequest request) {
        if (deletedAttachmentList != null) {
            for (TwitterAttachment attachment : deletedAttachmentList) {
                try {
                    if (attachment.getAttachmentId() == null) continue;
                    twitterService.removeAttachment(twitterContent, attachment);
                }
                catch (RepositoryCheckedException e) {
                    logger.error((Object)"Unable to delete file", (Throwable)e);
                    ActionMessages am = new ActionMessages();
                    am.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.contentrepository", (Object)attachment.getFilename()));
                    this.saveErrors(request, am);
                }
            }
            deletedAttachmentList.clear();
        }
        if (attachmentList != null) {
            for (TwitterAttachment attachment : attachmentList) {
                if (attachment.getAttachmentId() != null) continue;
                twitterService.saveAttachment(twitterContent, attachment);
            }
        }
        return deletedAttachmentList;
    }

    public ActionForward upload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws InvalidParameterException, FileNotFoundException, RepositoryCheckedException, IOException, TwitterApplicationException {
        TwitterAuthoringForm twitterForm = (TwitterAuthoringForm)form;
        ITwitterService twitterService = TwitterServiceProxy.getTwitterService(this.getServlet().getServletContext());
        Long content_id = TwitterWebUtil.convertToLong(twitterForm.getToolContentID());
        this.checkContentId(content_id);
        TwitterContent twitterContent = twitterService.retrieveTwitter(content_id);
        ActionMessages errors = new ActionMessages();
        FileValidatorUtil.validateFileSize((FormFile)twitterForm.getOnlineFile(), (boolean)true, (ActionMessages)errors);
        FileValidatorUtil.validateFileSize((FormFile)twitterForm.getOfflineFile(), (boolean)true, (ActionMessages)errors);
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
            return mapping.findForward("authoringContent");
        }
        if (twitterForm.getOnlineFile() != null && twitterForm.getOnlineFile().getFileName().trim().length() != 0 || twitterForm.getOfflineFile() != null && twitterForm.getOfflineFile().getFileName().trim().length() != 0) {
            boolean isOnlineFile = twitterForm.getOnlineFile() != null && twitterForm.getOnlineFile().getFileName().trim().length() != 0;
            FormFile theFile = isOnlineFile ? twitterForm.getOnlineFile() : twitterForm.getOfflineFile();
            String fileType = isOnlineFile ? "ONLINE" : "OFFLINE";
            SessionMap map = this.getSessionMap(request, twitterForm);
            List attachmentList = (List)map.get((Object)"attachmentList");
            List deletedAttachmentList = (List)map.get((Object)"deletedAttachmentList");
            deletedAttachmentList = this.moveToDelete(theFile.getFileName(), isOnlineFile, attachmentList, deletedAttachmentList);
            try {
                NodeKey node = twitterService.uploadFile(theFile.getInputStream(), theFile.getFileName(), theFile.getContentType(), fileType);
                TwitterAttachment file = new TwitterAttachment();
                file.setFilename(theFile.getFileName());
                file.setOnlineFile(isOnlineFile);
                file.setTwitterContent(twitterContent);
                file.setUuid(node.getUuid());
                file.setVersionId(node.getVersion());
                attachmentList.add(file);
                map = TwitterWebUtil.addUploadsToSession(map, request, attachmentList, deletedAttachmentList);
                twitterForm.setOfflineFile(null);
                twitterForm.setOnlineFile(null);
            }
            catch (FileNotFoundException e) {
                logger.error((Object)"Unable to uploadfile", (Throwable)e);
                throw new TwitterApplicationException("Unable to upload file, exception was " + e.getMessage());
            }
            catch (IOException e) {
                logger.error((Object)"Unable to uploadfile", (Throwable)e);
                throw new TwitterApplicationException("Unable to upload file, exception was " + e.getMessage());
            }
            catch (RepositoryCheckedException e) {
                logger.error((Object)"Unable to uploadfile", (Throwable)e);
                throw new TwitterApplicationException("Unable to upload file, exception was " + e.getMessage());
            }
        }
        twitterForm.setMethod("Instructions");
        return mapping.findForward("authoringContent");
    }

    private List moveToDelete(String filename, boolean isOnline, List attachmentsList, List deletedAttachmentsList) {
        return this.moveToDelete(filename, isOnline, null, attachmentsList, deletedAttachmentsList);
    }

    private List moveToDelete(Long uuid, List attachmentsList, List deletedAttachmentsList) {
        return this.moveToDelete(null, false, uuid, attachmentsList, deletedAttachmentsList);
    }

    private List moveToDelete(String filename, boolean isOnline, Long uuid, List attachmentsList, List deletedAttachmentsList) {
        List deletedList;
        List list = deletedList = deletedAttachmentsList != null ? deletedAttachmentsList : TwitterWebUtil.setupDeletedAttachmentList();
        if (attachmentsList != null) {
            Iterator iter = attachmentsList.iterator();
            TwitterAttachment attachment = null;
            while (iter.hasNext() && attachment == null) {
                TwitterAttachment value = (TwitterAttachment)iter.next();
                if (uuid != null) {
                    if (!uuid.equals(value.getUuid())) continue;
                    attachment = value;
                    continue;
                }
                if (value.isOnlineFile() != isOnline || !value.getFilename().equals(filename)) continue;
                attachment = value;
            }
            if (attachment != null) {
                deletedList.add(attachment);
                attachmentsList.remove(attachment);
            }
        }
        return deletedList;
    }

    public ActionForward deleteAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws InvalidParameterException, RepositoryCheckedException, TwitterApplicationException {
        TwitterAuthoringForm twitterForm = (TwitterAuthoringForm)form;
        Long uuid = twitterForm.getDeleteFileUuid();
        if (uuid == null) {
            String error = "Unable to continue. The file uuid is missing.";
            logger.error((Object)error);
            throw new TwitterApplicationException(error);
        }
        SessionMap map = this.getSessionMap(request, twitterForm);
        List attachmentList = (List)map.get((Object)"attachmentList");
        List deletedAttachmentList = (List)map.get((Object)"deletedAttachmentList");
        deletedAttachmentList = this.moveToDelete(uuid, attachmentList, deletedAttachmentList);
        twitterForm.setMethod("Instructions");
        return mapping.findForward("authoringContent");
    }

    private void checkContentId(Long contentId) {
        if (contentId == null) {
            String error = "Unable to continue. Tool content id missing.";
            throw new TwitterApplicationException(error);
        }
    }

    private SessionMap getSessionMap(HttpServletRequest request, TwitterAuthoringForm twitterForm) {
        return (SessionMap)request.getSession().getAttribute(twitterForm.getSessionMapID());
    }

    private String parseTags(String s) {
        Boolean b = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        String t = s.trim();
        String[] hashtags = t.split(",");
        for (int i = 0; i < hashtags.length; ++i) {
            b = false;
            hashtags[i] = hashtags[i].trim();
            for (int j = 0; j < arrayList.size(); ++j) {
                if (!hashtags[i].equals(arrayList.get(j).toString())) continue;
                b = true;
                break;
            }
            if (b.booleanValue()) continue;
            arrayList.add(hashtags[i]);
        }
        t = "";
        for (int k = 0; k < arrayList.size(); ++k) {
            t = k == 0 ? t + arrayList.get(k).toString() : t + "," + arrayList.get(k).toString();
        }
        return t;
    }

    public static String getRandomString(int length) {
        String charset = "!0123456789abcdefghijklmnopqrstuvwxyz";
        Random rand = new Random(System.currentTimeMillis());
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int pos = rand.nextInt(charset.length());
            sb.append(charset.charAt(pos));
        }
        return sb.toString();
    }
}

