/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.twitter.web;

import java.io.IOException;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.ToolSessionManager;
import org.lamsfoundation.lams.tool.exception.DataMissingException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.twitter.TwitterApplicationException;
import org.lamsfoundation.lams.tool.twitter.TwitterContent;
import org.lamsfoundation.lams.tool.twitter.TwitterSession;
import org.lamsfoundation.lams.tool.twitter.TwitterUser;
import org.lamsfoundation.lams.tool.twitter.TwitterUserTweet;
import org.lamsfoundation.lams.tool.twitter.service.ITwitterService;
import org.lamsfoundation.lams.tool.twitter.service.TwitterServiceProxy;
import org.lamsfoundation.lams.tool.twitter.util.TwitterWebUtil;
import org.lamsfoundation.lams.tool.twitter.web.TwitterLearnerForm;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.session.SessionManager;
import winterwell.jtwitter.Twitter;
import winterwell.jtwitter.TwitterException;

public class TwitterLearnerAction
extends LamsDispatchAction {
    static Logger logger = Logger.getLogger((String)TwitterLearnerAction.class.getName());

    public Long getUserID(HttpServletRequest request) {
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        if (user == null) {
            MessageResources resources = this.getResources(request);
            String error = resources.getMessage("error.missingParam", (Object)"User");
            logger.error((Object)error);
            throw new TwitterApplicationException(error);
        }
        return new Long(user.getUserID().longValue());
    }

    public ActionForward finish(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws TwitterApplicationException, ToolException, DataMissingException, ServletException, IOException {
        TwitterLearnerForm learnerForm = (TwitterLearnerForm)form;
        Long userID = this.getUserID(request);
        Long toolSessionID = TwitterWebUtil.convertToLong(learnerForm.getToolSessionID());
        if (toolSessionID == null) {
            String error = "Unable to continue. The parameters tool session id is missing";
            logger.error((Object)error);
            throw new TwitterApplicationException(error);
        }
        ITwitterService twitterService = TwitterServiceProxy.getTwitterService(this.getServlet().getServletContext());
        ToolSessionManager sessionMgrService = TwitterServiceProxy.getTwitterSessionManager(this.getServlet().getServletContext());
        ToolAccessMode mode = WebUtil.getToolAccessMode((String)learnerForm.getMode());
        if (mode == ToolAccessMode.LEARNER || mode == ToolAccessMode.AUTHOR) {
            String nextActivityUrl;
            TwitterSession twitterSession = twitterService.retrieveTwitterSession(toolSessionID);
            TwitterUser twitterUser = twitterService.retrieveTwitterUserBySession(userID, toolSessionID);
            twitterUser.setUserStatus("COMPLETED");
            twitterService.updateTwitterSession(twitterSession);
            twitterService.updateTwitterUser(twitterUser);
            TwitterContent twitterContent = twitterService.retrieveTwitterBySessionID(toolSessionID);
            if (twitterContent.getReflectOnActivity()) {
                NotebookEntry entry = twitterService.getEntry(toolSessionID, CoreNotebookConstants.NOTEBOOK_TOOL, "fptwit10", userID.intValue());
                if (entry == null) {
                    twitterService.createNotebookEntry(toolSessionID, CoreNotebookConstants.NOTEBOOK_TOOL, "fptwit10", userID.intValue(), learnerForm.getReflectionText());
                } else {
                    entry.setEntry(learnerForm.getReflectionText());
                    entry.setLastModified(new Date());
                    twitterService.updateEntry(entry);
                }
            }
            try {
                nextActivityUrl = sessionMgrService.leaveToolSession(toolSessionID, this.getUserID(request));
            }
            catch (DataMissingException e) {
                log.error((Object)e);
                throw new ServletException((Throwable)e);
            }
            catch (ToolException e) {
                log.error((Object)e);
                throw new ServletException((Throwable)e);
            }
            response.sendRedirect(nextActivityUrl);
            return null;
        }
        request.setAttribute("readOnlyMode", (Object)"true");
        return mapping.findForward("displayLearnerContent");
    }

    public ActionForward reflect(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws TwitterApplicationException {
        ITwitterService twitterService = TwitterServiceProxy.getTwitterService(this.getServlet().getServletContext());
        TwitterLearnerForm learnerForm = (TwitterLearnerForm)form;
        Long toolSessionID = TwitterWebUtil.convertToLong(learnerForm.getToolSessionID());
        TwitterContent twitterContent = twitterService.retrieveTwitterBySessionID(toolSessionID);
        request.setAttribute("reflectInstructions", (Object)twitterContent.getReflectInstructions());
        request.setAttribute("title", (Object)twitterContent.getTitle());
        NotebookEntry entry = twitterService.getEntry(toolSessionID, CoreNotebookConstants.NOTEBOOK_TOOL, "fptwit10", this.getUserID(request).intValue());
        if (entry != null) {
            request.setAttribute("reflectEntry", (Object)entry.getEntry());
        }
        return mapping.findForward("reflectOnActivity");
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws TwitterApplicationException {
        HttpSession session = request.getSession(true);
        ITwitterService twitterService = TwitterServiceProxy.getTwitterService(this.getServlet().getServletContext());
        TwitterLearnerForm learnerForm = (TwitterLearnerForm)form;
        TwitterUser twitterUser = new TwitterUser();
        twitterUser.setUid(Long.parseLong(learnerForm.getUserID()));
        TwitterContent twitterContent = new TwitterContent(Long.parseLong(learnerForm.getContentID()));
        Twitter twitterInstance = new Twitter(session.getAttribute("twitterUsername").toString(), session.getAttribute("twitterPassword").toString());
        String pictureURL = twitterInstance.getUser(learnerForm.getTwitterUsername()).getProfileImageUrl().toString();
        TwitterUserTweet twitterUserTweet = new TwitterUserTweet(twitterUser, twitterContent, learnerForm.getTweet(), learnerForm.getTwitterUsername(), new Date(), pictureURL);
        try {
            if (twitterInstance.isValidLogin()) {
                twitterInstance.setStatus(learnerForm.getTweet());
                twitterService.saveTwitterUserTweet(twitterUserTweet);
                request.setAttribute("success", (Object)"El tweet se ha guardado con \u00e9xito!");
            } else {
                request.setAttribute("errors", (Object)"No se ha podido autentificar en twitter");
            }
        }
        catch (TwitterException te) {
            request.setAttribute("errors", (Object)("No se ha podido guardar el tweet por el siguiente error: " + te.getAdditionalInfo()));
        }
        return mapping.findForward("learnerContentAction");
    }
}

