/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.twitter.web;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.lamsfoundation.lams.tool.exception.DataMissingException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.twitter.TwitterApplicationException;
import org.lamsfoundation.lams.tool.twitter.TwitterContent;
import org.lamsfoundation.lams.tool.twitter.service.ITwitterService;
import org.lamsfoundation.lams.tool.twitter.service.TwitterServiceProxy;
import org.lamsfoundation.lams.tool.twitter.util.TwitterWebUtil;
import org.lamsfoundation.lams.tool.twitter.web.TwitterLearnerTwitterForm;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import winterwell.jtwitter.Twitter;

public class TwitterLearnerTwitterAction
extends LamsDispatchAction {
    public ActionForward show(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws TwitterApplicationException, ToolException, DataMissingException, ServletException, IOException {
        TwitterContent twitterContent = null;
        TwitterLearnerTwitterForm twitterForm = (TwitterLearnerTwitterForm)form;
        Long toolSessionID = TwitterWebUtil.convertToLong(twitterForm.getToolSessionID());
        ITwitterService twitterService = TwitterServiceProxy.getTwitterService(this.getServlet().getServletContext());
        twitterContent = twitterService.retrieveTwitterBySessionID(toolSessionID);
        twitterForm.copyValuesIntoForm(twitterContent.getTitle());
        return mapping.findForward("loginTwitter");
    }

    public ActionForward login(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws TwitterApplicationException, ToolException, DataMissingException, ServletException, IOException {
        TwitterLearnerTwitterForm twitterForm = (TwitterLearnerTwitterForm)form;
        ActionErrors errors = twitterForm.validate(mapping, request);
        if (errors.size() == 0) {
            if (this.validateLogin(twitterForm.getTwitterUsername(), twitterForm.getTwitterPassword())) {
                HttpSession session = request.getSession(true);
                session.setAttribute("twitterUsername", (Object)twitterForm.getTwitterUsername());
                session.setAttribute("twitterPassword", (Object)twitterForm.getTwitterPassword());
                return mapping.findForward("successTwitter");
            }
            errors.add("", new ActionMessage("error.twitter.login.failed"));
        }
        ActionMessage actionMessage = (ActionMessage)errors.get().next();
        request.setAttribute("errors", (Object)actionMessage.getKey());
        twitterForm.setTwitterUsername("");
        twitterForm.setTwitterPassword("");
        return mapping.findForward("loginTwitter");
    }

    public ActionForward logout(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws TwitterApplicationException, ToolException, DataMissingException, ServletException, IOException {
        HttpSession session = request.getSession(true);
        session.removeAttribute("twitterUsername");
        session.removeAttribute("twitterPassword");
        return mapping.findForward("loginTwitter");
    }

    private boolean validateLogin(String username, String password) {
        Twitter twitter = new Twitter(username, password);
        return twitter.isValidLogin();
    }
}

