/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.twitter.web;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.tool.twitter.TwitterApplicationException;
import org.lamsfoundation.lams.tool.twitter.TwitterContent;
import org.lamsfoundation.lams.tool.twitter.TwitterSession;
import org.lamsfoundation.lams.tool.twitter.TwitterUser;
import org.lamsfoundation.lams.tool.twitter.dto.ReflectionDTO;
import org.lamsfoundation.lams.tool.twitter.service.ITwitterService;
import org.lamsfoundation.lams.tool.twitter.service.TwitterServiceProxy;
import org.lamsfoundation.lams.tool.twitter.util.TwitterWebUtil;
import org.lamsfoundation.lams.tool.twitter.web.TwitterMonitoringForm;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;

public class TwitterMonitoringAction
extends LamsDispatchAction {
    static Logger logger = Logger.getLogger((String)TwitterMonitoringAction.class.getName());
    public static final String FORM = "TwitterMonitoringForm";
    public static final String SUMMARY_TABID = "1";
    public static final String INSTRUCTIONS_TABID = "2";
    public static final String EDITACTIVITY_TABID = "3";
    public static final String STATISTICS_TABID = "4";

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws TwitterApplicationException {
        Long toolContentId = TwitterWebUtil.convertToLong(request.getParameter("toolContentID"));
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        if (toolContentId == null) {
            String error = "Unable to continue. Tool content id missing";
            logger.error((Object)error);
            throw new TwitterApplicationException(error);
        }
        TwitterMonitoringForm monitorForm = new TwitterMonitoringForm();
        ITwitterService twitterService = TwitterServiceProxy.getTwitterService(this.getServlet().getServletContext());
        TwitterContent content = twitterService.retrieveTwitter(toolContentId);
        monitorForm.setTitle(content.getTitle());
        monitorForm.setContent(content.getContent());
        monitorForm.setOnlineInstructions(content.getOnlineInstructions());
        monitorForm.setOfflineInstructions(content.getOfflineInstructions());
        monitorForm.setAttachmentsList(TwitterWebUtil.setupAttachmentList(twitterService, content));
        monitorForm.setContentEditable("true");
        HashMap<String, String> mapParameters = new HashMap<String, String>();
        mapParameters.put("toolContentID", toolContentId.toString());
        mapParameters.put("defineLater", "true");
        mapParameters.put("contentFolderID", contentFolderID);
        monitorForm.setParametersToAppend(mapParameters);
        monitorForm.setTotalLearners(twitterService.calculateTotalNumberOfUsers(toolContentId));
        Set sessions = content.getTwitterSessions();
        Iterator i = sessions.iterator();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        ArrayList<ReflectionDTO> reflections = new ArrayList<ReflectionDTO>();
        while (i.hasNext()) {
            TwitterSession session = (TwitterSession)i.next();
            int numUsersInSession = twitterService.getNumberOfUsersInSession(session);
            map.put(session.getTwitterSessionName(), new Integer(numUsersInSession));
            if (!content.getReflectOnActivity()) continue;
            List sessionUsers = twitterService.getUsersBySession(session.getTwitterSessionId());
            for (int j = 0; j < sessionUsers.size(); ++j) {
                TwitterUser twitterUser = (TwitterUser)sessionUsers.get(j);
                NotebookEntry twitterEntry = twitterService.getEntry(session.getTwitterSessionId(), CoreNotebookConstants.NOTEBOOK_TOOL, "fptwit10", twitterUser.getUserId().intValue());
                if (twitterEntry == null) continue;
                ReflectionDTO dto = new ReflectionDTO(twitterEntry);
                dto.setExternalId(session.getTwitterSessionId());
                dto.setUserId(twitterUser.getUserId());
                dto.setUsername(twitterUser.getUsername());
                reflections.add(dto);
            }
        }
        monitorForm.setGroupStatsMap(map);
        request.setAttribute("reflectOnActivity", (Object)content.getReflectOnActivity());
        request.setAttribute("reflectInstructions", (Object)content.getReflectInstructions());
        request.setAttribute("reflections", reflections);
        String currentTab = WebUtil.readStrParam((HttpServletRequest)request, (String)"currentTab", (boolean)true);
        monitorForm.setCurrentTab(currentTab != null ? currentTab : SUMMARY_TABID);
        request.setAttribute(FORM, (Object)monitorForm);
        return mapping.findForward("monitorPage");
    }

    public ActionForward viewReflection(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws TwitterApplicationException {
        TwitterUser twitterUser;
        Long userId = TwitterWebUtil.convertToLong(request.getParameter("userID"));
        Long toolSessionId = TwitterWebUtil.convertToLong(request.getParameter("toolSessionID"));
        ITwitterService twitterService = TwitterServiceProxy.getTwitterService(this.getServlet().getServletContext());
        NotebookEntry twitterEntry = twitterService.getEntry((twitterUser = twitterService.retrieveTwitterUser(userId, toolSessionId)).getTwitterSession().getTwitterSessionId(), CoreNotebookConstants.NOTEBOOK_TOOL, "fptwit10", userId.intValue());
        if (twitterEntry != null) {
            request.setAttribute("twitterEntry", (Object)twitterEntry.getEntry());
            request.setAttribute("name", (Object)twitterUser.getFullname());
        }
        return mapping.findForward("monitorReflectionPage");
    }
}

