/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.deploy;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.dbutils.DbUtils;
import org.lamsfoundation.lams.tool.deploy.DBTask;
import org.lamsfoundation.lams.tool.deploy.DeployException;

public class ToolDBUpdater
extends DBTask {
    private String toolSignature;
    private String toolVersion;
    private String toolCompatibleVersion;
    private boolean toolExists;
    private boolean toolNewer;
    private boolean compatibleVersion;

    public void execute() {
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement("UPDATE lams_tool SET tool_version = \"" + this.toolVersion + "\" WHERE tool_signature  = \"" + this.toolSignature + "\"");
            stmt.execute();
        }
        catch (SQLException sqlex) {
            try {
                throw new DeployException("Could not set tool version", sqlex);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(stmt);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((Statement)stmt);
    }

    public void checkInstalledVersion() {
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet results = null;
        try {
            stmt = conn.prepareStatement("SELECT tool_version FROM lams_tool WHERE tool_signature=\"" + this.toolSignature + "\"");
            results = stmt.executeQuery();
            if (results.first()) {
                this.toolExists = true;
                double dbVersion = Double.parseDouble(results.getString("tool_version"));
                double instVersion = Double.parseDouble(this.toolVersion);
                this.toolNewer = instVersion > dbVersion;
            } else {
                this.toolExists = false;
            }
            stmt = conn.prepareStatement("SELECT config_value FROM lams_configuration WHERE config_key=\"ServerVersionNumber\"");
            results = stmt.executeQuery();
            if (results.first()) {
                double instVersion;
                String dbVersionStr = results.getString("config_value");
                double dbVersion = Double.parseDouble(dbVersionStr.substring(dbVersionStr.lastIndexOf(46) + 1));
                if (dbVersion < (instVersion = Double.parseDouble(this.toolCompatibleVersion.substring(this.toolCompatibleVersion.lastIndexOf(46) + 1)))) {
                    System.out.println("The minimum ServerVersionNumber \"" + this.toolCompatibleVersion + "\" for install tool " + this.toolSignature + " " + this.toolVersion + " is higher than the current installed \"" + dbVersionStr + "\"");
                    System.out.println("BUILD FAILED");
                    System.exit(0);
                } else {
                    this.compatibleVersion = true;
                }
            } else {
                throw new DeployException("Could not get the ServerVersionNumber from the database.");
            }
            conn.close();
        }
        catch (SQLException sqlex) {
            try {
                throw new DeployException("Problem checking tool version compatibility", sqlex);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(stmt);
                DbUtils.closeQuietly(results);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((Statement)stmt);
        DbUtils.closeQuietly((ResultSet)results);
    }

    public void activateTool(String toolSig, int flag) throws SQLException {
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet results = null;
        try {
            stmt = conn.prepareStatement("UPDATE lams_tool SET valid_flag = " + flag + " WHERE tool_signature  = \"" + toolSig + "\"");
            stmt.execute();
            stmt = conn.prepareStatement("SELECT learning_library_id FROM lams_tool WHERE tool_signature=\"" + this.toolSignature + "\"");
            results = stmt.executeQuery();
            if (results.first()) {
                double llid = results.getDouble("learning_library_id");
                stmt = conn.prepareStatement("UPDATE lams_learning_library SET valid_flag = " + flag + " WHERE learning_library_id  = \"" + llid + "\"");
                stmt.execute();
            }
        }
        catch (SQLException se) {
            try {
                throw new DeployException("Could not activate/de-activate tool for update");
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(stmt);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((Statement)stmt);
    }

    public void hideTool(String toolSig) throws SQLException {
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet results = null;
        try {
            stmt = conn.prepareStatement("UPDATE lams_tool SET valid_flag = 1 WHERE tool_signature  = \"" + toolSig + "\"");
            stmt.execute();
            stmt = conn.prepareStatement("SELECT learning_library_id FROM lams_tool WHERE tool_signature=\"" + this.toolSignature + "\"");
            results = stmt.executeQuery();
            if (results.first()) {
                double llid = results.getDouble("learning_library_id");
                stmt = conn.prepareStatement("UPDATE lams_learning_library SET valid_flag = 0 WHERE learning_library_id  = \"" + llid + "\"");
                stmt.execute();
            }
        }
        catch (SQLException se) {
            try {
                throw new DeployException("Error hiding tool: " + toolSig);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(stmt);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((Statement)stmt);
    }

    public String queryTool(String toolSig, String column) {
        PreparedStatement stmt;
        block4: {
            String string;
            Connection conn = this.getConnection();
            stmt = null;
            ResultSet results = null;
            try {
                stmt = conn.prepareStatement("select " + column + " from lams_tool where tool_signature= \"" + toolSig + "\"");
                System.out.println("SQL stmt: " + stmt);
                results = stmt.executeQuery();
                if (!results.first()) break block4;
                string = results.getString(column);
            }
            catch (SQLException se) {
                try {
                    throw new DeployException("Could not get entry from lams_tool: " + column + "\n" + se.getMessage());
                }
                catch (Throwable throwable) {
                    DbUtils.closeQuietly(stmt);
                    throw throwable;
                }
            }
            DbUtils.closeQuietly((Statement)stmt);
            return string;
        }
        DbUtils.closeQuietly((Statement)stmt);
        return "ERROR";
    }

    public void setToolSignature(String sig) {
        this.toolSignature = sig;
    }

    public void setToolVersion(String ver) {
        this.toolVersion = ver;
    }

    public boolean getToolExists() {
        return this.toolExists;
    }

    public boolean getToolNewer() {
        return this.toolNewer;
    }

    public String getToolCompatibleVersion() {
        return this.toolCompatibleVersion;
    }

    public void setToolCompatibleVersion(String ver) {
        this.toolCompatibleVersion = ver;
    }

    public boolean getToolCompatible() {
        return this.compatibleVersion;
    }
}

