/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.twitter;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.tool.twitter.TwitterContent;

public class TwitterAttachment
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -3471513404550541296L;
    private static Logger log = Logger.getLogger(TwitterAttachment.class);
    private Long attachmentId;
    private TwitterContent twitterContent;
    private String filename;
    private Long uuid;
    private Long versionId;
    private boolean onlineFile;
    public static final String TYPE_ONLINE = "ONLINE";
    public static final String TYPE_OFFLINE = "OFFLINE";

    public TwitterAttachment() {
    }

    public TwitterAttachment(TwitterContent twitterContent, String filename, boolean isOnline) {
        this.twitterContent = twitterContent;
        this.filename = filename;
        this.onlineFile = isOnline;
    }

    public TwitterAttachment(TwitterContent twitterContent, String filename, Long uuid, Long versionId, boolean isOnline) {
        this.twitterContent = twitterContent;
        this.filename = filename;
        this.uuid = uuid;
        this.versionId = versionId;
        this.onlineFile = isOnline;
    }

    public Object clone() {
        Object obj = null;
        try {
            obj = super.clone();
        }
        catch (CloneNotSupportedException e) {
            log.error((Object)("Clone " + TwitterAttachment.class + " not supported"));
        }
        return obj;
    }

    public Long getAttachmentId() {
        return this.attachmentId;
    }

    public void setAttachmentId(Long attachmentId) {
        this.attachmentId = attachmentId;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public boolean isOnlineFile() {
        return this.onlineFile;
    }

    public void setOnlineFile(boolean isOnline) {
        this.onlineFile = isOnline;
    }

    public TwitterContent getTwitterContent() {
        return this.twitterContent;
    }

    public void setTwitterContent(TwitterContent twitterContent) {
        this.twitterContent = twitterContent;
    }

    public Long getUuid() {
        return this.uuid;
    }

    public void setUuid(Long uuid) {
        this.uuid = uuid;
    }

    public Long getVersionId() {
        return this.versionId;
    }

    public void setVersionId(Long versionId) {
        this.versionId = versionId;
    }

    public String getFileProperty() {
        if (this.isOnlineFile()) {
            return TYPE_ONLINE;
        }
        return TYPE_OFFLINE;
    }

    public void setFileProperty(String fileProperty) {
        this.onlineFile = StringUtils.equals((String)TYPE_ONLINE, (String)fileProperty);
    }

    public String returnKeyName() {
        return this.getFilename() + "-" + this.getFileProperty();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TwitterAttachment)) {
            return false;
        }
        TwitterAttachment castOther = (TwitterAttachment)other;
        return new EqualsBuilder().append((Object)this.getAttachmentId(), (Object)castOther.getAttachmentId()).append((Object)this.getFilename(), (Object)castOther.getFilename()).append((Object)this.getUuid(), (Object)castOther.getUuid()).append((Object)this.getVersionId(), (Object)castOther.getVersionId()).append(this.isOnlineFile(), castOther.isOnlineFile()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getAttachmentId()).toHashCode();
    }
}

