/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.twitter.util;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.lamsfoundation.lams.tool.twitter.TwitterAttachment;
import org.lamsfoundation.lams.tool.twitter.TwitterContent;
import org.lamsfoundation.lams.tool.twitter.service.ITwitterService;
import org.lamsfoundation.lams.web.util.SessionMap;

public class TwitterWebUtil {
    private TwitterWebUtil() {
    }

    public static Long convertToLong(String id) {
        try {
            return new Long(id);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static SessionMap addUploadsToSession(SessionMap sessionMap, HttpServletRequest request, List attachmentList, List deletedAttachmentList) {
        SessionMap map = sessionMap != null ? sessionMap : new SessionMap();
        map.put((Object)"attachmentList", (Object)(attachmentList != null ? attachmentList : new ArrayList()));
        map.put((Object)"deletedAttachmentList", (Object)(deletedAttachmentList != null ? deletedAttachmentList : new ArrayList()));
        request.getSession().setAttribute(map.getSessionID(), (Object)map);
        return map;
    }

    public static List setupAttachmentList(ITwitterService twitterService, TwitterContent twitter) {
        ArrayList<TwitterAttachment> attachmentList = new ArrayList<TwitterAttachment>();
        if (twitterService != null && twitter != null) {
            List attachmentIdList = twitterService.getAttachmentIdsFromContent(twitter);
            for (int i = 0; i < attachmentIdList.size(); ++i) {
                TwitterAttachment file = twitterService.retrieveAttachment((Long)attachmentIdList.get(i));
                attachmentList.add(file);
            }
        }
        return attachmentList;
    }

    public static List setupDeletedAttachmentList() {
        return new ArrayList();
    }
}

