/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.twitter.web;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.twitter.TwitterContent;
import org.lamsfoundation.lams.tool.twitter.TwitterSession;
import org.lamsfoundation.lams.tool.twitter.service.ITwitterService;
import org.lamsfoundation.lams.tool.twitter.service.TwitterServiceProxy;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.servlet.AbstractExportPortfolioServlet;

public class TwitterExportServlet
extends AbstractExportPortfolioServlet {
    private final String FILENAME = "twitter_main.html";
    private static Logger logger = Logger.getLogger(TwitterExportServlet.class);

    protected String doOfflineExport(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies) {
        if (this.toolContentID == null && this.toolSessionID == null) {
            String error = "Tool content Id or and session Id are null. Unable to set activity title";
            logger.error((Object)error);
        } else {
            ITwitterService service = TwitterServiceProxy.getTwitterService(this.getServletContext());
            TwitterContent content = null;
            if (this.toolContentID != null) {
                content = service.retrieveTwitter(this.toolContentID);
            } else {
                TwitterSession session = service.retrieveTwitterSession(this.toolSessionID);
                if (session != null) {
                    content = session.getTwitterContent();
                }
            }
            if (content != null) {
                this.activityTitle = content.getTitle();
            }
        }
        return super.doOfflineExport(request, response, directoryName, cookies);
    }

    public String doExport(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies) {
        String mode = WebUtil.readStrParam((HttpServletRequest)request, (String)"mode");
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
        String url = basePath + "/exportPortfolio.do";
        String urlWithParameters = null;
        if (mode.equals(ToolAccessMode.LEARNER.toString())) {
            urlWithParameters = this.appendParametersToLearnerExportURL(request, url);
        } else if (mode.equals(ToolAccessMode.TEACHER.toString())) {
            urlWithParameters = this.appendParametersToTeacherExportURL(request, url);
        }
        this.writeResponseToFile(urlWithParameters, directoryName, "twitter_main.html", cookies);
        return "twitter_main.html";
    }
}

