/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.twitter.dao.hibernate;

import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.lamsfoundation.lams.tool.twitter.TwitterUserTweet;
import org.lamsfoundation.lams.tool.twitter.dao.ITwitterUserTweetDAO;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class TwitterUserTweetDAO
extends HibernateDaoSupport
implements ITwitterUserTweetDAO {
    @Override
    public int getNumberOfTweetsByUser(Long toolContentId, Long userId) {
        DetachedCriteria detachedCriteria = DetachedCriteria.forClass(TwitterUserTweet.class);
        detachedCriteria.add((Criterion)Restrictions.eq((String)"twitterUser.uid", (Object)userId));
        detachedCriteria.add((Criterion)Restrictions.eq((String)"twitterContent.uid", (Object)toolContentId));
        detachedCriteria.addOrder(Order.desc((String)"creationDate"));
        List tweets = this.getHibernateTemplate().findByCriteria(detachedCriteria);
        if (tweets != null) {
            return tweets.size();
        }
        return 0;
    }

    @Override
    public TwitterUserTweet[] getTwitterUserTweet(Long toolContentId) {
        DetachedCriteria detachedCriteria = DetachedCriteria.forClass(TwitterUserTweet.class);
        detachedCriteria.add((Criterion)Restrictions.eq((String)"twitterContent.uid", (Object)toolContentId));
        detachedCriteria.addOrder(Order.desc((String)"creationDate"));
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        hibernateTemplate.setMaxResults(4);
        List tweets = hibernateTemplate.findByCriteria(detachedCriteria);
        if (tweets != null && tweets.size() == 0) {
            return null;
        }
        TwitterUserTweet[] response = new TwitterUserTweet[tweets.size()];
        for (int i = 0; i < tweets.size(); ++i) {
            response[i] = (TwitterUserTweet)tweets.get(i);
        }
        return response;
    }

    @Override
    public TwitterUserTweet[] getTwitterUserTweetByUser(Long userId, Long toolContentId) {
        DetachedCriteria detachedCriteria = DetachedCriteria.forClass(TwitterUserTweet.class);
        detachedCriteria.add((Criterion)Restrictions.eq((String)"twitterUser.uid", (Object)userId));
        detachedCriteria.add((Criterion)Restrictions.eq((String)"twitterContent.uid", (Object)toolContentId));
        detachedCriteria.addOrder(Order.desc((String)"creationDate"));
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        hibernateTemplate.setMaxResults(4);
        List tweets = hibernateTemplate.findByCriteria(detachedCriteria);
        if (tweets != null && tweets.size() == 0) {
            return null;
        }
        TwitterUserTweet[] response = new TwitterUserTweet[tweets.size()];
        for (int i = 0; i < tweets.size(); ++i) {
            response[i] = (TwitterUserTweet)tweets.get(i);
        }
        return response;
    }

    @Override
    public void saveTwitterUserTweet(TwitterUserTweet twitterUserTweet) {
        this.getHibernateTemplate().save((Object)twitterUserTweet);
    }
}

