/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.deploy;

import org.lamsfoundation.lams.tool.deploy.DeployException;
import org.lamsfoundation.lams.tool.deploy.UpdateApplicationXmlTask;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AddModuleToApplicationXmlTask
extends UpdateApplicationXmlTask {
    protected void updateApplicationXml(Document doc) throws DeployException {
        Element moduleElement = this.findElementWithModule(doc);
        if (moduleElement != null) {
            doc.getDocumentElement().removeChild(moduleElement);
        }
        moduleElement = doc.createElement("module");
        Element javaElement = doc.createElement("java");
        javaElement.appendChild(doc.createTextNode(this.module));
        moduleElement.appendChild(javaElement);
        doc.getDocumentElement().appendChild(moduleElement);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2 || args[0] == null) {
            throw new IllegalArgumentException("Usage: AddModuleToApplicationXmlTask <lams.ear path> <module>");
        }
        try {
            System.out.println("Attempting to update " + args[0] + "/META-INF/application.xml");
            AddModuleToApplicationXmlTask addModuleTask = new AddModuleToApplicationXmlTask();
            addModuleTask.setLamsEarPath(args[0]);
            addModuleTask.setModule(args[1]);
            addModuleTask.execute();
            System.out.println("application.xml update completed");
        }
        catch (Exception ex) {
            System.out.println("Application.xml update failed: " + ex.getMessage());
            ex.printStackTrace();
        }
    }
}

