/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.deploy;

import java.io.IOException;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.types.FileSet;
import org.lamsfoundation.lams.tool.deploy.CreatePackageTask;
import org.lamsfoundation.lams.tool.deploy.DeployException;
import org.lamsfoundation.lams.tool.deploy.DeployToolConfig;
import org.xml.sax.SAXException;

public class CreateToolPackageTask
extends CreatePackageTask {
    private Vector<FileSet> filesets = new Vector();

    public void execute() {
        this.log("Create Deployment Package.");
        this.deployConfig = new DeployToolConfig(this.outputPath.toString());
        if (this.configFile != null && this.configFile.length() > 0L) {
            this.log("Applying configuration file " + this.configFile.getAbsolutePath());
            try {
                this.deployConfig.updateConfigurationProperties(this.configFile.getAbsolutePath());
            }
            catch (ParserConfigurationException e) {
                throw new DeployException("Could not parse the XML file" + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new DeployException("Please check the file or file path. Error is:" + e.getMessage(), e);
            }
            catch (SAXException e) {
                throw new DeployException(e.getMessage());
            }
        }
        this.applyParameters();
        this.applyFilesets("languageFiles", this.filesets);
        this.deployConfig.validateProperties();
        this.deployConfig.convertForInstallers();
        try {
            this.writeConfigFile();
        }
        catch (IOException e) {
            throw new DeployException(e.getMessage());
        }
    }

    public void addLanguageFiles(Object input) {
        System.out.println("input to addLanguageFiles is " + input);
    }

    public void addFileset(FileSet fileset) {
        this.filesets.add(fileset);
    }
}

