/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.deploy;

import org.lamsfoundation.lams.tool.deploy.DeployException;
import org.lamsfoundation.lams.tool.deploy.UpdateApplicationXmlTask;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RemoveModuleFromApplicationXmlTask
extends UpdateApplicationXmlTask {
    public static void main(String[] args) throws Exception {
        if (args.length < 2 || args[0] == null) {
            throw new IllegalArgumentException("Usage: RemoveModuleFromApplicationXmlTask <lams.ear path>");
        }
        try {
            System.out.println("Attempting to update " + args[0] + "\\META-INF\\application.xml");
            RemoveModuleFromApplicationXmlTask remModAppTask = new RemoveModuleFromApplicationXmlTask();
            remModAppTask.setLamsEarPath(args[0]);
            remModAppTask.setModule(args[1]);
            remModAppTask.execute();
            System.out.println("application.xml update completed");
        }
        catch (Exception ex) {
            System.out.println("Application.xml update failed: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    protected void updateApplicationXml(Document doc) throws DeployException {
        Element moduleElement = this.findElementWithModule(doc);
        if (moduleElement == null) {
            System.out.println("No element found with text matching: " + this.module);
            System.out.println("application.xml update completed");
            System.exit(0);
        } else {
            System.out.println("Doc: " + moduleElement.compareDocumentPosition(doc));
            System.out.println("Doc: " + doc.getDocumentElement().toString());
            System.out.println("Module: " + moduleElement.getNodeName());
            doc.getDocumentElement().removeChild(moduleElement);
        }
    }
}

