/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.deploy;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.lamsfoundation.lams.tool.deploy.InsertToolContextClasspathTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddCustomWebXmlContexts {
    public static void main(String[] args) throws Exception {
        if (args.length < 4 || args[0] == null) {
            throw new IllegalArgumentException("Usage: AddModuleToApplicationXmlTask <lams.ear path> <dbUser> <dbPass> <dbUrl>");
        }
        try {
            LinkedList<String> defualtTools = new LinkedList<String>();
            defualtTools.add("lafrum11");
            defualtTools.add("lanb11");
            defualtTools.add("laqa11");
            defualtTools.add("lasbmt11");
            defualtTools.add("larsrc11");
            defualtTools.add("lavote11");
            defualtTools.add("lasurv11");
            defualtTools.add("lascrb11");
            defualtTools.add("lamc11");
            defualtTools.add("lantbk11");
            defualtTools.add("lachat11");
            AddCustomWebXmlContexts addWebXml = new AddCustomWebXmlContexts();
            List<String[]> customToolContexts = addWebXml.getCustomToolContexts(defualtTools, args[1], args[2], args[3]);
            LinkedList<String> warFiles = new LinkedList<String>();
            warFiles.add("lams-central.war");
            warFiles.add("lams-learning.war");
            warFiles.add("lams-monitoring.war");
            addWebXml.addContexts(args[0], customToolContexts, warFiles);
        }
        catch (Exception ex) {
            System.out.println("Application.xml update failed: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public void addContexts(String eardir, List<String[]> contexts, List<String> warFiles) {
        InsertToolContextClasspathTask updateWebXmlTask = new InsertToolContextClasspathTask();
        updateWebXmlTask.setLamsEarPath(eardir);
        updateWebXmlTask.setArchivesToUpdate(warFiles);
        for (String[] context : contexts) {
            updateWebXmlTask.setApplicationContextPath(context[0]);
            updateWebXmlTask.setJarFileName(context[1]);
            updateWebXmlTask.execute();
        }
    }

    public List<String[]> getCustomToolContexts(List<String> defualtTools, String dbUser, String dbPass, String dbUrl) throws SQLException, ClassNotFoundException {
        System.out.println("User: " + dbUser);
        System.out.println("Pass: " + dbPass);
        System.out.println("Url: " + dbUrl);
        Class.forName("com.mysql.jdbc.Driver");
        Connection conn = DriverManager.getConnection(dbUrl, dbUser, dbPass);
        conn.setAutoCommit(false);
        ArrayList<String[]> contexts = new ArrayList<String[]>();
        String queryStr = "SELECT context_file, classpath_addition FROM lams_tool WHERE ";
        Iterator<String> it = defualtTools.iterator();
        while (it.hasNext()) {
            String toolSig = it.next();
            queryStr = queryStr + "tool_signature!=\"" + toolSig + "\" ";
            if (!it.hasNext()) continue;
            queryStr = queryStr + "AND ";
        }
        System.out.println("Query string: " + queryStr);
        PreparedStatement query = conn.prepareStatement(queryStr);
        ResultSet results = query.executeQuery();
        while (results.next()) {
            String[] context = new String[]{results.getString("context_file"), results.getString("classpath_addition")};
            contexts.add(context);
        }
        return contexts;
    }
}

