/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.deploy;

import java.io.File;
import org.lamsfoundation.lams.tool.deploy.DeployException;
import org.lamsfoundation.lams.tool.deploy.FilesTask;

public class DeployLanguageFilesTask
extends FilesTask {
    public static final String NUM_FILES = "numFiles";
    private static final String LANGUAGE_JAR_DIRECTORY = "lams-dictionary.jar";
    protected String dictionaryPacket;

    public void execute() throws DeployException {
        this.getLamsEar();
        File dictionaryDir = this.getLamsDictionary();
        int count = 0;
        for (String languageFilename : this.deployFiles) {
            System.out.println("Copying file " + languageFilename + " to " + dictionaryDir);
            this.copyFile(languageFilename, dictionaryDir);
            ++count;
        }
    }

    private File getLamsDictionary() throws DeployException {
        String packageName;
        File dictionaryDir;
        if (this.dictionaryPacket != null) {
            this.dictionaryPacket = this.dictionaryPacket.replace('.', File.separatorChar);
        }
        if (!(dictionaryDir = new File(packageName = this.lamsEarPath + File.separator + LANGUAGE_JAR_DIRECTORY + File.separator + this.dictionaryPacket)).exists()) {
            dictionaryDir.mkdirs();
        } else {
            if (!dictionaryDir.isDirectory()) {
                throw new DeployException("Dictionary package " + packageName + " exists but it is not a directory");
            }
            if (!dictionaryDir.canWrite()) {
                throw new DeployException("Dictionary package " + packageName + " exists but it is not writable");
            }
        }
        return dictionaryDir;
    }

    public String getDictionaryPacket() {
        return this.dictionaryPacket;
    }

    public void setDictionaryPacket(String dictionaryPacket) {
        this.dictionaryPacket = dictionaryPacket;
    }
}

