/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: ITwitterUserTweetDAO.java,v 1.8 2006/09/19 06:37:24 jliew Exp $$ */
package org.lamsfoundation.lams.tool.twitter.dao;

import java.util.List;

import org.lamsfoundation.lams.tool.twitter.TwitterUserTweet;
import org.lamsfoundation.lams.tool.twitter.TwitterContent;

/**
 * @author fpenya
 * 
 * <p>Interface for the TwitterSession DAO, defines methods needed to access/modify
 * twitter users tweets (made by learners of the twitter activity) </p>
 */
public interface ITwitterUserTweetDAO {
    
    /**
	 * <p> Return the number of persistent tweets
	 * with the given tool content id <code>toolContentId</code>
	 * who has the user id <code>userId</code>
	 * returns 0 if no tweet is found.</p>
	 * 
	 * @param toolContentId. The tool content id of the current activity.
	 * @param userId. The id of the learner
	 * @return the number of persistent tweets with (with the given tool content id and user id) or 0 if not found.
	 */
    public int getNumberOfTweetsByUser(Long toolContentId, Long userId);
    
    /**
	 * <p> Return the persistent instances of the first four TwitterUserTweet
	 * with the given tool content id <code>toolContentId</code>
	 * returns null if no tweet is found.</p>
	 * 
	 * @param toolContentId. The tool content id of the current activity.
	 * @return the persistent instances of the first four TwitterUserTweet or null if not found.
	 */
    public TwitterUserTweet[] getTwitterUserTweet(Long toolContentId);
    
    /**
	 * <p> Return the persistent instances of the first four TwitterUserTweet
	 * who has the user id <code>userId</code> and tool content id
	 * <code>toolContentId</code>
	 * returns null if not found.</p>
	 * 
	 * @param userId. The id of the learner
	 * @param toolContentId. The tool content id of the current activity.
	 * @return the persistent instances of the first four TwitterUserTweet or null if not found.
	 */
    public TwitterUserTweet[] getTwitterUserTweetByUser(Long userId, Long toolContentId);
    
    /**
	 * <p>Persist the given persistent instance of TwitterUserTweet.</p>
	 * 
	 * @param twitterUserTweet The instance of TwitterUserTweet to persist.
	 */
    public void saveTwitterUserTweet(TwitterUserTweet twitterUserTweet);


}
