/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: TwitterLearnerForm.java,v 1.9 2006/09/19 06:37:23 jliew Exp $$ */
package org.lamsfoundation.lams.tool.twitter.web;

import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.lamsfoundation.lams.tool.twitter.TwitterContent;
import org.lamsfoundation.lams.tool.twitter.TwitterUserTweet;


/**
 * Creation Date: 19-05-05
 *  
 * ----------------XDoclet Tags--------------------
 * 
 * @struts:form name="TwitterLearnerForm" type="org.lamsfoundation.lams.tool.twitter.web.TwitterLearnerForm"
 *
 * ----------------XDoclet Tags--------------------
 */

public class TwitterLearnerForm extends ActionForm{
    
    private static final long serialVersionUID = -669035956406254875L;

    static Logger logger = Logger.getLogger(TwitterLearnerForm.class.getName());
    
    private String title;
    
    private String content;
    
    private String status;
    
    private String toolSessionID;
    
    private String contentID;
    
    private String userID;
    
    private String method;
    
    private String mode;
    
    private Boolean readOnly;
    
    private String reflectionText;
    
    private String twitterUsername;
    
    private String teacherTwitterUsername;
    
    private String[] learnersTwitterUsernames;
    
    private String[] hashtags;
    
    private int tweetNumber;
    
    private String tweet;
    
    private TwitterUserTweet[] userTweets;
    
    private int currentTweets;
    
    /**
     * @return Returns the toolSessionID.
     */
    public String getToolSessionID() {
        return toolSessionID;
    }
    /**
     * @param toolSessionID The toolSessionID to set.
     */
    public void setToolSessionID(String toolSessionID) {
        this.toolSessionID = toolSessionID;
    }
    
    /**
     * @return Returns the contentID.
     */
    public String getContentID() {
        return contentID;
    }
    /**
     * @param toolSessionID The toolSessionID to set.
     */
    public void setContentID(String contentID) {
        this.contentID = contentID;
    }
    
    /**
     * @return Returns the userID.
     */
    public String getUserID() {
        return userID;
    }
    /**
     * @param toolSessionID The toolSessionID to set.
     */
    public void setUserID(String userID) {
        this.userID = userID;
    }
    
    /**
     * @return Returns the content.
     */
    public String getContent() {
        return content;
    }
    /**
     * @param content The content to set.
     */
    public void setContent(String content) {
        this.content = content;
    }
    /**
     * @return Returns the title.
     */
    public String getTitle() {
        return title;
    }
    /**
     * @param title The title to set.
     */
    public void setTitle(String title) {
        this.title = title;
    }
    
    /**
     * @return Returns the method.
     */
    public String getMethod() {
        return method;
    }
    /**
     * @param method The method to set.
     */
    public void setMethod(String method) {
        this.method = method;
    }

    public void reset(){
	this.content = null;
	this.title = null;
	this.toolSessionID = null;
	this.contentID = null;
	this.userID = null;
	this.method = null;
	this.mode = null;
	this.teacherTwitterUsername = null;
	this.learnersTwitterUsernames = null;
	this.hashtags = null;
	this.tweetNumber = 0;
	this.tweet = null;
	this.userTweets = null;
    }
    
    public void copyValuesIntoForm(TwitterContent content, boolean readOnly, String mode, TwitterUserTweet[] userTweets, int currentTweets)
    {
        setTitle(content.getTitle());
        setContent(content.getContent());
        setMode(mode);
        setReadOnly(new Boolean(readOnly));
        setTeacherTwitterUsername(content.getTeacherTwitterUsername());
        setLearnersTwitterUsernames(content.getLearnersTwitterUsernames().split(","));
        setHashtags(content.getHashtags().split(","));
        setTweetNumber(content.getTweetNumber());
        setUserTweets(userTweets);
        setCurrentTweets(currentTweets);
    }
    
    /**
     * @return Returns the mode.
     */
    public String getMode() {
        return mode;
    }
    /**
     * @param mode The mode to set.
     */
    public void setMode(String mode) {
        this.mode = mode;
    }

    /**
     * @return Returns the readOnly flag.
     */
    public Boolean getReadOnly() {
	return readOnly;
    }
    
    /**
     * @param readOnly The readOnly flag to set.
     */
    public void setReadOnly(Boolean readOnly) {
	this.readOnly = readOnly;
    }
    
    /**
     * @return Returns the reflection text.
     */
    public String getReflectionText() {
        return reflectionText;
    }

    /**
     * @param reflectionText The reflection text to set.
     */
    public void setReflectionText(String reflectionText) {
        this.reflectionText = reflectionText;
    }
    
    /**
     * @return Returns the current twitter username.
     */
    public String getTwitterUsername() {
        return twitterUsername;
    }

    /**
     * @param twitterUsername The current twitter username to set.
     */
    public void setTwitterUsername(String twitterUsername) {
        this.twitterUsername = twitterUsername;
    }
    
    /**
     * @return Returns the teacher's twitter username.
     */
    public String getTeacherTwitterUsername() {
        return teacherTwitterUsername;
    }

    /**
     * @param teacherTwitterUsername The teacher's twitter username to set.
     */
    public void setTeacherTwitterUsername(String teacherTwitterUsername) {
        this.teacherTwitterUsername = teacherTwitterUsername;
    }
    
    /**
     * @return Returns the leaners' twitter usernames.
     */
    public String[] getLearnersTwitterUsernames() {
        return learnersTwitterUsernames;
    }

    /**
     * @param learnersTwitterUsernames The learners' twitter usernames to set.
     */
    public void setLearnersTwitterUsernames(String[] learnersTwitterUsernames) {
        this.learnersTwitterUsernames = learnersTwitterUsernames;
    }
    
    /**
     * @return Returns the hashtags.
     */
    public String[] getHashtags() {
        return hashtags;
    }

    /**
     * @param hashtags The hashtags to set.
     */
    public void setHashtags(String[] hashtags) {
        this.hashtags = hashtags;
    }
    
    /**
     * @return Returns the tweet number.
     */
    public int getTweetNumber() {
        return tweetNumber;
    }

    /**
     * @param tweetNumber The tweet number to set.
     */
    public void setTweetNumber(int tweetNumber) {
        this.tweetNumber = tweetNumber;
    }
    
    /**
     * @return Returns the current tweets posted by the user.
     */
    public int getCurrentTweets() {
        return currentTweets;
    }

    /**
     * @param currentTweets The current tweets posted by the user to set.
     */
    public void setCurrentTweets(int currentTweets) {
        this.currentTweets = currentTweets;
    }
    
    /**
     * @return Returns the tweet.
     */
    public String getTweet() {
        return tweet;
    }

    /**
     * @param tweet The tweet to set.
     */
    public void setTweet(String tweet) {
        this.tweet = tweet;
    }
    
    /**
     * @return Returns the user tweets.
     */
    public TwitterUserTweet[] getUserTweets() {
        return userTweets;
    }

    /**
     * @param userTweets The userTweets to set.
     */
    public void setUserTweets(TwitterUserTweet[] userTweets) {
        this.userTweets = userTweets;
    }
}
