/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: TestTwitterUserDAO.java,v 1.8 2008/09/03 07:40:45 asukkar Exp $$ */
package org.lamsfoundation.lams.tool.twitter.dao.hibernate;

import org.lamsfoundation.lams.tool.twitter.TwitterDataAccessTestCase;
import org.lamsfoundation.lams.tool.twitter.TwitterUser;
import org.lamsfoundation.lams.tool.twitter.TwitterSession;
import org.lamsfoundation.lams.tool.twitter.TwitterContent;

/**
 * @author mtruong
 */
public class TestTwitterUserDAO extends TwitterDataAccessTestCase {
    
    private TwitterUser twitterUser;
    private TwitterSession twitterSession;
    
    private TwitterContent content;
   
    private boolean cleanContentData = true;
    
    public TestTwitterUserDAO(String name)
    {
        super(name);
    }
    
    /**
     * @see TwitterDataAccessTestCase#setUp()
     */
	 protected void setUp() throws Exception {
	 	super.setUp();
       
        initAllData();
     
    }
	 
	 protected void tearDown() throws Exception {
	    
	     if(cleanContentData)
	     {
	     	cleanTwitterContentData(TEST_NB_ID);
	     }
	 }
	 
	

	 public void testGetTwitterUserByID()
	 {
	     twitterUser = twitterUserDAO.getTwitterUser(TEST_USER_ID, TEST_SESSION_ID);
	     
	     assertEqualsForTwitterUser(twitterUser);
	     
	     Long nonExistentUserId = new Long(23321);
	     assertUserObjectIsNull(nonExistentUserId);
	 }
	 
	 public void testSaveTwitterUser()
	 {
	     TwitterSession sessionToReference = twitterSessionDAO.findTwitterSessionById(TEST_SESSION_ID);
	    
	     Long newUserId = new Long(3849);
	     
	     TwitterUser newUserObj = new TwitterUser(newUserId,
	             											sessionToReference);
	        
	     sessionToReference.getTwitterUsers().add(newUserObj);
	     twitterSessionDAO.updateTwitterSession(sessionToReference);
	     
	     twitterUserDAO.saveTwitterUser(newUserObj);   
	        
	     //Retrieve the newly added session object and test its values
	     twitterUser = twitterUserDAO.getTwitterUser(newUserId, TEST_SESSION_ID);
	     
	     assertEquals(twitterUser.getUserId(), newUserId);
	     assertEquals(twitterUser.getTwitterSession().getTwitterSessionId(),TEST_SESSION_ID);
	 } 
	 public void testUpdateTwitterUser()
	 {
	     twitterUser = twitterUserDAO.getTwitterUser(TEST_USER_ID, TEST_SESSION_ID);
	     twitterUser.setUserStatus(TwitterUser.COMPLETED);
	     twitterUserDAO.updateTwitterUser(twitterUser);
	     
	     TwitterUser modifiedUser = twitterUserDAO.getTwitterUser(TEST_USER_ID, TEST_SESSION_ID);
	     assertEquals(modifiedUser.getUserStatus(), TwitterUser.COMPLETED);
	 }
	 
	 public void testRemoveTwitterUserById()
	 {
	    twitterUser = twitterUserDAO.getTwitterUser(TEST_USER_ID, TEST_SESSION_ID);
	    twitterSession = twitterUser.getTwitterSession();
	    twitterSession.getTwitterUsers().remove(twitterUser);
	     
	     twitterUserDAO.removeTwitterUser(TEST_USER_ID);
	     twitterSessionDAO.updateTwitterSession(twitterSession);
	    
	     assertUserObjectIsNull(TEST_USER_ID);
	 }
	 
	 public void testRemoveTwitterUser()
	 {
	     twitterUser = twitterUserDAO.getTwitterUser(TEST_USER_ID, TEST_SESSION_ID);
		 twitterSession = twitterUser.getTwitterSession();
		 twitterSession.getTwitterUsers().remove(twitterUser);
		     
		 twitterUserDAO.removeTwitterUser(twitterUser);
		 twitterSessionDAO.updateTwitterSession(twitterSession);
		    
		 assertUserObjectIsNull(TEST_USER_ID);
	 }
	 
	 public void testGetNumberOfUsers()
	 {
	     twitterUser = twitterUserDAO.getTwitterUser(TEST_USER_ID, TEST_SESSION_ID);
	     twitterSession = twitterUser.getTwitterSession();
	     int numberOfUsers = twitterUserDAO.getNumberOfUsers(twitterSession);
	     System.out.println(numberOfUsers);
	     assertEquals(numberOfUsers, 1);
	 } 
	 
	 public void testGetTwitterUserBySession()
	 {
	 	Long newSessionId = new Long(3456);
	 	
	 	TwitterContent content = twitterDAO.findTwitterContentById(TEST_NB_ID);
	 	
	 	TwitterSession newSession = new TwitterSession(newSessionId, "Session "+newSessionId, content);
	 	content.getTwitterSessions().add(newSession);
	 	twitterDAO.updateTwitterContent(content);
	 	twitterSessionDAO.saveTwitterSession(newSession);
	 	
	 	//add the test user to a new session
	 	TwitterUser existingUserNewSession = new TwitterUser(TEST_USER_ID, newSession);
	 	newSession.getTwitterUsers().add(existingUserNewSession);
	 	twitterSessionDAO.updateTwitterSession(newSession);
	 	
	 	twitterUserDAO.saveTwitterUser(existingUserNewSession);
	 	
	 	//add a different user to the session
	 	Long newUserId= new Long(3458);
	 	TwitterUser newUser = new TwitterUser(newUserId, newSession);
	 	newSession.getTwitterUsers().add(newUser);
	 	twitterSessionDAO.updateTwitterSession(newSession);
	 	twitterUserDAO.saveTwitterUser(newUser);
	 	
	 	//retrieve test user by session	id	
	 	TwitterUser retrievedUser = twitterUserDAO.getTwitterUserBySession(TEST_USER_ID, newSessionId);
	 	assertEquals(retrievedUser.getUserId(), TEST_USER_ID);
	 	assertEquals(retrievedUser.getTwitterSession().getTwitterSessionId(), newSessionId);
	 	
	 	TwitterUser retrievedUser2 = twitterUserDAO.getTwitterUserBySession(newUserId, newSessionId);
	 	assertEquals(retrievedUser2.getUserId(), newUserId);
	 	assertEquals(retrievedUser.getTwitterSession().getTwitterSessionId(), newSessionId);
	 	
	 } 
	 
	 
	 
	


}
