<%@ include file="/includes/taglibs.jsp"%>

<style>

#learnerTwitterClient, #learnerTwitterStatus{
	font-family: arial, sans-serif, helvetica;
}

#learnerTwitterStatus{
}

#learnerTwitterClient{
	width: 100%;
	height: 460px;
	background-color: #ECF3FC;
}

#learnerTwitterTimeline{
	width: 65%;
	float: left;
}

#learnerTwitterTimeline p, #learnerTwitterInfo p{
	font-size: 12pt;
	text-decoration: underline;
}

#learnerTwitterInfo{
	width: 35%;
	float: right;
}

#learnerTwitterInfo table{
	margin-left: 20px
}

#learnerTwitterInfo table tr td{
	font-size: 14px !important;
}

#learnerTwitterInfo input{
	margin-left: 20px;
}

#learnerTwitterInfo a{
	text-align: center;
}

#learnerTwitterTimelineTweets{
	height: 300px;
	margin: 10px 5px 0 20px;
}

#learnerTwitterTimelineTweets table tr{
	height: 60px;
}

.tweetTime, .tweet{
	padding: 0 !important;
	text-decoration: none !important;
	margin: 0 !important;
}

.tweetTime{
	font-size: 11px !important;
	color: #BDBDBD;
}

.tweet{
	font-size: 12px !important;
	color: #000000
}

.twitterPic, .twitterTweetInfo{
}

.twitterPic{
	width: 15%;
}

.twitterTweetInfo{
	width: 85%;
}

.twitterTweetInfoLabel{
	width: 35%
}

#learnerTwitterTimelinePost{
	height: 160px;
	margin: 0 20px 0 20px;
}

#learnerTwitterTimelinePost form{
	margin-left: 20px;
}

#learnerTwitterTimelinePost form textarea{
	width: 80%;
}

#errors, #success{
	padding-bottom: 10px;
}

#errors{
	color: #FF0000;
}

#success{
	color: #00CD00;
}

#tweetCounter{
	font-size: 20px;
	text-align: right;
	width: 80%;
}

</style>

<script type="text/javascript">
	function fillTweet(txt){
		document.getElementById('tweet').value = document.getElementById('tweet').value + txt;
		updateTweetCounter();
	}

	function submitForm(methodName){
		var f = document.getElementById('learnerForm');
		var m = document.getElementById('methodVar');
		m.value=methodName
		f.submit();
	}

	function updateTweetCounter(){
		var tweetLength = document.getElementById('tweet').value.length;
		var counter = document.getElementById('tweetCounter');
		counter.innerHTML = 140 - tweetLength;
	}
</script>

<div id="content">
	<fmt:parseNumber var="currentUserTweetsInt" type="number" value="${currentUserTweets}" />
	
	<h1>
		<c:out value="${TwitterLearnerForm.title}" escapeXml="false" />
	</h1>
	
	<p id="learnerTwitterStatus"><fmt:message key="twitter.loggedAs"></fmt:message> <c:out value="${TwitterLearnerForm.twitterUsername}" escapeXml="false" /> (<html:link href="twitter.do?method=logout">no eres tu?</html:link>)</p>
	<c:if test="${not empty errors}">
		<div id="errors"><c:out value="${errors}" escapeXml="false" /></div>
	</c:if>
	
	<c:if test="${not empty success}">
		<div id="success"><c:out value="${success}" escapeXml="false" /></div>
	</c:if>
	
	
	<div id="learnerTwitterClient">
		<div id="learnerTwitterTimeline">
		
			<div id="learnerTwitterTimelineTweets">
				<p><fmt:message key="twitter.timelineTitle"></fmt:message></p>
				<table>
				
				<c:forEach var="tweet" items="${TwitterLearnerForm.userTweets}" varStatus="loopStatus">
					<bean:define id="tweetIndex">
						<c:out value="${loopStatus.index}"></c:out>
					</bean:define>
					<tr>
						<td class ="twitterPic"><html:image src="${TwitterLearnerForm.userTweets[tweetIndex].twitterPicture}"></html:image></td>
						<td class ="twitterTweetInfo"><p class="tweetTime"><c:out value="${TwitterLearnerForm.userTweets[tweetIndex].creationDate}" escapeXml="false" /></p>
						<p class="tweet"><c:out value="${TwitterLearnerForm.userTweets[tweetIndex].tweet}" escapeXml="false" /></p>
						</td>
					</tr>
				</c:forEach>
	
				</table>
			</div>
			
			<div id="learnerTwitterTimelinePost">
				<p><fmt:message key="twitter.postTitle"></fmt:message></p>
				<div id="tweetCounter">140</div>
				<html:form action="/learner.do">
					<html:hidden property="method" value="save"/>
					<html:hidden property="twitterUsername" value="${TwitterLearnerForm.twitterUsername}"/>
					<html:hidden property="toolSessionID" value="${TwitterLearnerForm.toolSessionID}"/>
					<html:hidden property="contentID" value="${TwitterLearnerForm.contentID}"/>
					<html:hidden property="userID" value="${TwitterLearnerForm.userID}"/>
					<html:hidden property="mode" value="${TwitterLearnerForm.mode}"/>
					<html:textarea property="tweet" styleId="tweet" onkeyup="updateTweetCounter()"></html:textarea>
					<html:submit><fmt:message key="twitter.postSubmit"></fmt:message></html:submit>
				</html:form>
				
			
			</div>
		
		</div>
		
		<div id="learnerTwitterInfo">
			<p><fmt:message key="twitter.activityInfoTitle"></fmt:message></p>
			<table>
			<tr>
			<td class="twitterTweetInfoLabel"><fmt:message key="twitter.activityInfoTeacher"></fmt:message></td>
			<td><html:link href="Javascript:fillTweet('@${TwitterLearnerForm.teacherTwitterUsername}');">@<c:out value="${TwitterLearnerForm.teacherTwitterUsername}"></c:out></html:link></td>
			</tr>
			
			<tr>
			<td class="twitterTweetInfoLabel"><fmt:message key="twitter.activityInfoLearners"></fmt:message></td>
			<td>
			<c:forEach var="learner" items="${TwitterLearnerForm.learnersTwitterUsernames}" varStatus="loopStatus">
				<bean:define id="learnerIndex">
					<c:out value="${loopStatus.index}"></c:out>
				</bean:define>
				<html:link href="Javascript:fillTweet('@${TwitterLearnerForm.learnersTwitterUsernames[learnerIndex]}');" ><c:out value="@${TwitterLearnerForm.learnersTwitterUsernames[learnerIndex]}" escapeXml="false" /></html:link><br>
			</c:forEach>
			</td>
			</tr>
			
			<tr>
			<td class="twitterTweetInfoLabel"><fmt:message key="twitter.activityInfoHashtags"></fmt:message></td>
			<td>
			<c:forEach var="hashtag" items="${TwitterLearnerForm.hashtags}" varStatus="loopStatus">
				<bean:define id="hashtagIndex">
					<c:out value="${loopStatus.index}"></c:out>
				</bean:define>
				<html:link href="Javascript:fillTweet('#${TwitterLearnerForm.hashtags[hashtagIndex]}');" ><c:out value="#${TwitterLearnerForm.hashtags[hashtagIndex]}" escapeXml="false" /></html:link><br>
			</c:forEach>
			</td>
			</tr>
			</table>
			<p><fmt:message key="twitter.activityStatusTitle"></fmt:message></p>
			<div style="width:100%" align="center">
				<c:if test="${ 1 == TwitterLearnerForm.tweetNumber}">
					<html:image src="images/learner_activity_completed.png"></html:image><br/>
					<fmt:message key="twitter.activityComplete"></fmt:message><br/>
				</c:if>
				<c:if test="${ 1 < TwitterLearnerForm.tweetNumber}">
					<html:img src="images/learner_activity_pending.png"></html:img><br/>
					Llevas 1 de 2 tweets!<br/>
				</c:if>
				
				<c:if test="${TwitterLearnerForm.currentTweets == 0}">
					<html:link href="starter/learner.do?mode=${TwitterLearnerForm.mode}&toolSessionID=${TwitterLearnerForm.toolSessionID}&tweetMode=user"><fmt:message key="twitter.myTweets"></fmt:message></html:link>
				</c:if>
		
				
			</div>
		</div>
		
		
	
	</div>


	<html:form action="/learner" target="_self"
		onsubmit="disableFinishButton();" styleId="learnerForm">
		<html:hidden property="toolSessionID" />
		<html:hidden property="mode" />
		<c:choose>
			<c:when test="${reflectOnActivity}">
				<input type="hidden" id="methodVar" name="method" value="reflect" />
			</c:when>
			<c:otherwise>
				<input type="hidden" id="methodVar" name="method" value="finish" />
			</c:otherwise>
		</c:choose>

		<c:if test="${userFinished and reflectOnActivity}">
			<div class="small-space-top">
				<h2>
					${reflectInstructions}
				</h2>

				<c:choose>
					<c:when test="${empty reflectEntry}">
						<p>
							<em> <fmt:message key="message.no.reflection.available" />
							</em>
						</p>

					</c:when>

					<c:otherwise>
						<p>
							<lams:out escapeHtml="true" value="${reflectEntry}" />
						</p>
					</c:otherwise>

				</c:choose>

			</div>
		</c:if>

		<div class="space-bottom-top align-right">
			<c:if test="${not TwitterLearnerForm.readOnly}">
				<c:choose>
					<c:when test="${reflectOnActivity}">
						<html:button property="continueButton" styleClass="button"
							onclick="submitForm('reflect')">
							<fmt:message key="button.continue" />
						</html:button>
					</c:when>
					<c:otherwise>


						<html:link href="#" property="finishButton" styleClass="button"
							styleId="finishButton" onclick="submitForm('finish')">
							<span class="nextActivity"><fmt:message key="button.finish" /></span>
						</html:link>
					</c:otherwise>
				</c:choose>
			</c:if>
		</div>
	</html:form>
</div>




