package winterwell.jtwitter;
import java.util.Map;
import net.oauth.OAuth;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthMessage;
import net.oauth.OAuthServiceProvider;
import net.oauth.client.OAuthClient;
import net.oauth.client.OAuthResponseMessage;
import net.oauth.client.OAuthClient.ParameterStyle;
import net.oauth.http.HttpResponseMessage;

/**
 * This has a lot of dependencies - see http://code.google.com/p/oauth/
 * Which is why it's not included as standard in JTwitter 
 * @author John Kristian <jmkristian@gmail.com>
 * @authro Daniel
 *
 */
public class OAuthHttpClient implements Twitter.IHttpClient {

	public static final OAuthServiceProvider TWITTER_SERVICE_PROVIDER = new OAuthServiceProvider(
	        "http://twitter.com/oauth/request_token",
	        "http://twitter.com/oauth/authorize",
	        "http://twitter.com/oauth/access_token");

	private final OAuthAccessor accessor;
	private final OAuthClient client;

	public OAuthHttpClient(OAuthAccessor accessor, OAuthClient client) {
		this.accessor = accessor;
		this.client = client;
	}

	@Override
	public boolean canAuthenticate() {
		return accessor.accessToken != null;
	}

	@Override
	public String getPage(String uri, Map<String, String> vars, boolean authenticate) throws TwitterException {
		return access(OAuthMessage.GET, uri, vars, authenticate);
	}

	@Override
	public String post(String uri, Map<String, String> vars, boolean authenticate) throws TwitterException {
		return access(OAuthMessage.POST, uri, vars, authenticate);
	}

	private String access(String httpMethod, String url, Map<String, String> parameters, boolean authenticate)
	        throws TwitterException {
		try {
			OAuthMessage request = new OAuthMessage(httpMethod, url,
					(parameters == null) ? null : parameters.entrySet());
			request.getHeaders().add(
			        new OAuth.Parameter("User-Agent",
			                "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; .NET CLR 2.0.50727)"));
			if (authenticate) {
				assert accessor.accessToken != null && accessor.tokenSecret != null
				: "Need OAuth access token and secret for this method";
				request.addRequiredParameters(accessor);
			}
			OAuthResponseMessage response = client.access(request, getStyle(request));
			int statusCode = response.getHttpResponse().getStatusCode();
			if (statusCode != HttpResponseMessage.STATUS_OK) {
				throw new TwitterException(response.toOAuthProblemException());
			}
			return response.readBodyAsString();
		} catch (TwitterException t) {
			throw t;
		} catch (Exception e) {
			throw new TwitterException(e);
		}
	}

	private ParameterStyle getStyle(OAuthMessage request) {
		Object ps = accessor.consumer.getProperty(OAuthClient.PARAMETER_STYLE);
		ParameterStyle style = (ps != null) ? Enum.valueOf(ParameterStyle.class, ps.toString())
				: (OAuthMessage.POST.equals(request.method) ? ParameterStyle.BODY
						: ParameterStyle.QUERY_STRING);
		return style;
	}

}
