/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: TwitterUserTweetDAO.java,v 1.9 2006/09/19 06:37:25 jliew Exp $$ */
package org.lamsfoundation.lams.tool.twitter.dao.hibernate;

import java.util.List;

import org.hibernate.FlushMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.DetachedCriteria;
import org.lamsfoundation.lams.tool.twitter.dao.ITwitterUserTweetDAO;
import org.lamsfoundation.lams.tool.twitter.TwitterUser;
import org.lamsfoundation.lams.tool.twitter.TwitterUserTweet;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

/**
 * @author mtruong
 * <p>Hibernate implementation for database access to Twitter users' tweets for the twitter tool.</p>
 */
public class TwitterUserTweetDAO extends HibernateDaoSupport implements ITwitterUserTweetDAO{
   
    /** @see org.lamsfoundation.lams.tool.twitter.dao.ITwitterUserTweetDAO#getNumberOfTweetsByUser(java.lang.Long, java.lang.Long) */
    public int getNumberOfTweetsByUser(Long toolContentId, Long userId){
	DetachedCriteria detachedCriteria = DetachedCriteria.forClass(TwitterUserTweet.class);
	
	detachedCriteria.add(Restrictions.eq("twitterUser.uid", userId));
	detachedCriteria.add(Restrictions.eq("twitterContent.uid", toolContentId));
	detachedCriteria.addOrder(Order.desc("creationDate"));
	
	List tweets = getHibernateTemplate().findByCriteria(detachedCriteria);
	if(tweets != null){
	    return tweets.size();
	}
	else{
	    return 0;
	}
    }
  
    /** @see org.lamsfoundation.lams.tool.twitter.dao.ITwitterUserTweetDAO#getTwitterUserTweet(java.lang.Long) */
    public TwitterUserTweet[] getTwitterUserTweet(Long toolContentId)
    {
	DetachedCriteria detachedCriteria = DetachedCriteria.forClass(TwitterUserTweet.class);
	
	detachedCriteria.add(Restrictions.eq("twitterContent.uid", toolContentId));
	detachedCriteria.addOrder(Order.desc("creationDate"));	
	
	HibernateTemplate hibernateTemplate = getHibernateTemplate();
	hibernateTemplate.setMaxResults(4);
	
	List tweets = hibernateTemplate.findByCriteria(detachedCriteria);
	
	if(tweets!=null && tweets.size() == 0)
	{			
	    return null;
	}
	else
	{
	    TwitterUserTweet[] response = new TwitterUserTweet[tweets.size()];
	    for(int i = 0; i < tweets.size(); i++){
		response[i] = (TwitterUserTweet)tweets.get(i);
	    }
	    return response;
	}
    }
	
	/** @see org.lamsfoundation.lams.tool.twitter.dao.ITwitterUserDAO#getTwitterUserBySession(java.lang.Long, java.lang.Long)*/
	public TwitterUserTweet[] getTwitterUserTweetByUser(Long userId, Long toolContentId)
	{	
	    
	    DetachedCriteria detachedCriteria = DetachedCriteria.forClass(TwitterUserTweet.class);
	    
	    detachedCriteria.add(Restrictions.eq("twitterUser.uid", userId));
	    detachedCriteria.add(Restrictions.eq("twitterContent.uid", toolContentId));
	    detachedCriteria.addOrder(Order.desc("creationDate"));	
	    
	    HibernateTemplate hibernateTemplate = getHibernateTemplate();
	    hibernateTemplate.setMaxResults(4);
		
	    List tweets = hibernateTemplate.findByCriteria(detachedCriteria);
		
	    if(tweets!=null && tweets.size() == 0)
	    {			
		return null;
	    }
	    else
	    {
		TwitterUserTweet[] response = new TwitterUserTweet[tweets.size()];
		for(int i = 0; i < tweets.size(); i++){
		    response[i] = (TwitterUserTweet)tweets.get(i);
		}
		return response;
	    }
	}

	/** @see org.lamsfoundation.lams.tool.twitter.dao.ITwitterUserDAO#saveTwitterUser(org.lamsfoundation.lams.tool.twitter.TwitterUser) */
	public void saveTwitterUserTweet(TwitterUserTweet twitterUserTweet)
	{
	    this.getHibernateTemplate().save(twitterUserTweet);
	}
}
