/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: TestTwitterContentDAO.java,v 1.8 2006/09/17 06:26:25 fmalikoff Exp $$ */
package org.lamsfoundation.lams.tool.twitter.dao.hibernate;

import org.lamsfoundation.lams.tool.twitter.TwitterDataAccessTestCase;
import org.lamsfoundation.lams.tool.twitter.TwitterContent;
import org.lamsfoundation.lams.tool.twitter.dao.hibernate.TwitterContentDAO;
import org.lamsfoundation.lams.tool.twitter.TwitterSession;

/**
 * @author mtruong
 *
 * JUnit Test Cases to test the TwitterContentDAO class
 */
public class TestTwitterContentDAO extends TwitterDataAccessTestCase
{
	private boolean cleanContentData = true;
    
	public TestTwitterContentDAO(String name)
	{
		super(name);
	}
	
	 /**
     * @see TwitterDataAccessTestCase#setUp()
     */
	 protected void setUp() throws Exception {
        super.setUp();

        //set up default twitter content for each test
       	initAllData();
    }
	 
	/**
	 * @see TwitterDataAccessTestCase#tearDown()
	 */
    protected void tearDown() throws Exception 
    {    	
        //remove twitter content after each test
       if(cleanContentData)
        {
        	cleanTwitterContentData(TEST_NB_ID);
        }
    }
   
   public void testfindTwitterContentByID()
    {
       twitterContent = twitterDAO.findTwitterContentById(TEST_NB_ID);
       
        assertContentEqualsTestData(twitterContent);
    	
    
    	 // Test to see if trying to retrieve a non-existent object would 
    	 // return null or not.
    	 
    	Long nonExistentId = new Long(88777);
    	assertTwitterContentIsNull(nonExistentId);
       
//	   TwitterContent twitter = new TwitterContent(new Long(3600),	
//				TEST_TITLE,
//				TEST_CONTENT,
//				TEST_ONLINE_INSTRUCTIONS,
//				TEST_OFFLINE_INSTRUCTIONS,
//				TEST_DEFINE_LATER,
//				TEST_CONTENT_IN_USE,
//				TEST_FORCE_OFFLINE,
//				TEST_CREATOR_USER_ID,
//				TEST_DATE_CREATED,
//				TEST_DATE_UPDATED);
//
//	   twitterDAO.saveTwitterContent(twitter);
	   
	 // twitterDAO.removeTwitter(new Long(3600));
	//   twitterDAO.removeTwitter(twitterDAO.findTwitterContentById(new Long(3600)));
	   
	   
    } 
   
   public void testremoveTwitter()
   {
       cleanContentData = false;     
       
       twitterContent = twitterDAO.findTwitterContentById(TEST_NB_ID);
       
       twitterDAO.removeTwitter(twitterContent);
       
       assertTwitterSessionIsNull(TEST_SESSION_ID); //check if child table is deleted
  	   assertTwitterContentIsNull(TEST_NB_ID);
   } 
   
   public void testremoveTwitterById()
   {
       cleanContentData = false;
  	 	
	   
  	 	twitterDAO.removeTwitter(TEST_NB_ID);
  	 	
  	 	assertTwitterSessionIsNull(TEST_SESSION_ID);
  	 	assertTwitterContentIsNull(TEST_NB_ID);
   }
   
   public void testgetTwitterContentBySession()
   {
	   	twitterContent = twitterDAO.getTwitterContentBySession(TEST_SESSION_ID);
	   	
	   	assertContentEqualsTestData(twitterContent);
   }
   

   public void testsaveTwitterContent()
   {
   	/** 
   	 * an object already created when setUp() is called, so dont need to save another instance 
   	 * TODO: change this, actually test the save method
   	 */
   	
   	twitterContent = twitterDAO.findTwitterContentById(getTestTwitterId());
   	
   	assertContentEqualsTestData(twitterContent);
   	
   }
   
   public void testupdateTwitterContent()
   {
   	// Update the twitter to have a new value for its content field 
   	String newContent = "New updated content";
   	
   	twitterContent = twitterDAO.findTwitterContentById(getTestTwitterId());
   	twitterContent.setContent(newContent);
   	
   	twitterDAO.updateTwitterContent(twitterContent);
   	
   	//Check whether the value has been updated
   	
   	twitterContent = twitterDAO.findTwitterContentById(getTestTwitterId());
   	
   	assertEquals(twitterContent.getContent(), newContent);
   	
   } 
      
   public void testremoveTwitterSessions()
   {
   	
	   	twitterContent = twitterDAO.findTwitterContentById(getTestTwitterId());
	   	
	   	
	   	twitterDAO.removeTwitterSessions(twitterContent);
	   	twitterContent.getTwitterSessions().clear(); //Have to remove/empty the collection before deleting it.
	   	//otherwise exception will occur
	   	twitterDAO.updateTwitterContent(twitterContent);
	   	TwitterContent twitter = twitterDAO.findTwitterContentById(getTestTwitterId());
	   	assertNotNull(twitter);
	   	assertTwitterSessionIsNull(TEST_SESSION_ID);   	
   }
   
   public void testAddSession()
   {
       Long newSessionId = new Long(87);
       TwitterSession newSession = new TwitterSession(newSessionId);
       
       twitterDAO.addTwitterSession(TEST_NB_ID, newSession);
       
       TwitterSession retrievedSession = twitterSessionDAO.findTwitterSessionById(newSessionId);
       
       assertEquals(retrievedSession.getTwitterContent().getTwitterContentId(), TEST_NB_ID);
       
   }
   
   
 

  
}
