/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: TestTwitterSessionDAO.java,v 1.10 2008/09/03 07:40:45 asukkar Exp $$ */
package org.lamsfoundation.lams.tool.twitter.dao.hibernate;

import java.util.Date;
import java.util.List;
import java.util.Iterator;


import org.lamsfoundation.lams.tool.twitter.TwitterDataAccessTestCase;
import org.lamsfoundation.lams.tool.twitter.TwitterContent;
import org.lamsfoundation.lams.tool.twitter.TwitterSession;
import org.lamsfoundation.lams.tool.twitter.TwitterUser;



/**
 * @author mtruong
 *
 * JUnit Test Cases to test the TwitterSessionDAO class
 */
public class TestTwitterSessionDAO extends TwitterDataAccessTestCase {
	
	
	private TwitterSession twitterSession = null;
	private TwitterContent twitterContent = null;
	
	
	//private boolean cleanSessionContentData = false;
	private boolean cleanContentData = true;
	
	public TestTwitterSessionDAO(String name)
	{
		super(name);
	}
	
	 /**
     * @see TwitterDataAccessTestCase#setUp()
     */
	 protected void setUp() throws Exception {
	 	super.setUp();
       initAllData();
    }
	 
	/**
	 * @see TwitterDataAccessTestCase#tearDown()
	 */
    protected void tearDown() throws Exception {
        
        if(cleanContentData)
        {
        	super.cleanTwitterContentData(TEST_NB_ID);
        }
       
    }

  /* public void testgetTwitterSessionByUID()
    {
       twitterSession = twitterSessionDAO.getTwitterSessionByUID(new Long(1)); //default test data which is always in db
        
       assertEquals(twitterSession.getTwitterSessionId(), DEFAULT_SESSION_ID);
       assertEquals(twitterSession.getSessionStatus(), DEFAULT_SESSION_STATUS);
        
    } */
    
    public void testfindTwitterSessionById()
    {
        twitterSession = twitterSessionDAO.findTwitterSessionById(TEST_SESSION_ID);
        assertEqualsForSessionContent(twitterSession);
        
        Long nonExistentSessionId = new Long(7657);
        assertSessionObjectIsNull(nonExistentSessionId); 
    }
    
    public void testsaveTwitterSession()
    {
        TwitterContent twitterContentToReference = twitterDAO.findTwitterContentById(TEST_NB_ID);
        
        Long newSessionId = new Long(2222);
        Date newDateCreated = new Date(System.currentTimeMillis());
        TwitterSession newSessionObject = new TwitterSession(newSessionId,
        															"Session "+newSessionId,
                													twitterContentToReference,
                													newDateCreated,
                													TwitterSession.NOT_ATTEMPTED);
        
        twitterContentToReference.getTwitterSessions().add(newSessionObject);
        twitterDAO.updateTwitterContent(twitterContentToReference);
        
        twitterSessionDAO.saveTwitterSession(newSessionObject);
        
        //Retrieve the newly added session object and test its values
        
        twitterSession = twitterSessionDAO.findTwitterSessionById(newSessionId);
        
        assertEquals(twitterSession.getTwitterSessionId(), newSessionId);
        assertEquals(twitterSession.getSessionStartDate(), newDateCreated);
        
    } 
    
    public void testupdateTwitterSession()
    {
        twitterSession = twitterSessionDAO.findTwitterSessionById(TEST_SESSION_ID);
        
        twitterSession.setSessionStatus(TwitterSession.COMPLETED);
        
        twitterSessionDAO.updateTwitterSession(twitterSession);
        
        TwitterSession updatedSession = twitterSessionDAO.findTwitterSessionById(TEST_SESSION_ID);
        
        assertEquals(updatedSession.getSessionStatus(), TwitterSession.COMPLETED);
    } 
    
  /*  public void testremoveTwitterSessionByUID()
    {
        TwitterSession existingSession = twitterSessionDAO.findTwitterSessionById(TEST_SESSION_ID);
        Long uid = existingSession.getUid();
        
        TwitterContent referencedContent = existingSession.getTwitterContent();
        
        twitterSessionDAO.removeTwitterSessionByUID(uid);
        referencedContent.getTwitterSessions().remove(existingSession);
        
        twitterDAO.updateTwitterContent(referencedContent);
        
        assertSessionObjectIsNull(TEST_SESSION_ID);
    } */
    
    
    public void testremoveTwitterSessionById()
    {
        twitterSession = twitterSessionDAO.findTwitterSessionById(TEST_SESSION_ID);
        twitterContent = twitterSession.getTwitterContent();
        twitterContent.getTwitterSessions().remove(twitterSession);
        
        twitterSessionDAO.removeTwitterSession(TEST_SESSION_ID);
        
        twitterDAO.updateTwitterContent(twitterContent);
        
        assertSessionObjectIsNull(TEST_SESSION_ID);
        
    }
    
    public void testremoveTwitterSession()
    {
        twitterSession = twitterSessionDAO.findTwitterSessionById(TEST_SESSION_ID);
        twitterContent = twitterSession.getTwitterContent();
        twitterContent.getTwitterSessions().remove(twitterSession);
        
        twitterSessionDAO.removeTwitterSession(twitterSession);
        
        twitterDAO.updateTwitterContent(twitterContent);
        
        assertSessionObjectIsNull(TEST_SESSION_ID);
    } 
    
    public void testGetTwitterSessionByUser()
    {
        twitterSession = twitterSessionDAO.getTwitterSessionByUser(TEST_USER_ID);
        assertEqualsForSessionContent(twitterSession);
    }
    
    public void testRemoveTwitterUsers()
    {
        twitterSession = twitterSessionDAO.findTwitterSessionById(TEST_SESSION_ID);
        
        twitterSessionDAO.removeTwitterUsers(twitterSession);
        twitterSession.getTwitterUsers().clear();
        twitterSessionDAO.updateTwitterSession(twitterSession);
        
        TwitterSession ns = twitterSessionDAO.findTwitterSessionById(TEST_SESSION_ID);
        
        assertNotNull(ns);
        assertUserObjectIsNull(TEST_USER_ID);
    }
    
    public void testAddUsers()
    {
        Long newUserId = new Long(123);
        TwitterUser newUser = new TwitterUser(newUserId);
        
        twitterSessionDAO.addTwitterUsers(TEST_SESSION_ID, newUser);
        
        TwitterUser retrievedUser = twitterUserDAO.getTwitterUser(newUserId, TEST_SESSION_ID);
        
        assertEquals(retrievedUser.getTwitterSession().getTwitterSessionId(), TEST_SESSION_ID);
    }
    
    public void testGetSessionsFromContent()
    {
        twitterSession = twitterSessionDAO.findTwitterSessionById(TEST_SESSION_ID);
        TwitterContent content = twitterSession.getTwitterContent();
        List list = twitterSessionDAO.getSessionsFromContent(content);
        assertEquals(list.size(), 1);
        
        Iterator i = list.iterator();
        
        while (i.hasNext())
        {
            Long sessionID = (Long)i.next();
            assertEquals(sessionID, TEST_SESSION_ID);
        }
        
    }
   
}
