/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 * USA
 *
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $Id: TwitterPedagogicalPlannerForm.java,v 1.3 2009/02/13 17:46:44 marcin Exp $ */
package org.lamsfoundation.lams.tool.twitter.web;

import org.lamsfoundation.lams.tool.twitter.TwitterContent;
import org.lamsfoundation.lams.web.planner.PedagogicalPlannerActivityForm;

/**
 * @struts:form name="TwitterPedagogicalPlannerForm"
 *              type="org.lamsfoundation.lams.tool.twitter.web.TwitterPedagogicalPlannerForm"
 */
public class TwitterPedagogicalPlannerForm extends PedagogicalPlannerActivityForm {
    private String content;
    private String contentFolderID;

    public String getContentFolderID() {
	return contentFolderID;
    }

    public void setContentFolderID(String contentFolderID) {
	this.contentFolderID = contentFolderID;
    }

    public String getContent() {
	return content;
    }

    public void setContent(String instructions) {
	content = instructions;
    }

    public void fillForm(TwitterContent twitter) {
	if (twitter != null) {
	    String content = twitter.getContent();
	    setContent(content);
	    setToolContentID(twitter.getTwitterContentId());
	}
    }
}
