/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.signup.action;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.DynaActionForm;
import org.lamsfoundation.lams.tool.signup.model.SignupOrganisation;
import org.lamsfoundation.lams.tool.signup.service.SignupService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.Emailer;
import org.lamsfoundation.lams.util.HashUtil;
import org.lamsfoundation.lams.util.WebUtil;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class RegisterAction
extends Action {
    private static Logger log = Logger.getLogger(RegisterAction.class);
    private static SignupService signupService = null;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            DynaActionForm registerForm;
            String context;
            if (signupService == null) {
                WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
                signupService = (SignupService)wac.getBean("signupService");
            }
            if (StringUtils.isNotBlank((String)(context = WebUtil.readStrParam((HttpServletRequest)request, (String)"context", (boolean)true)))) {
                SignupOrganisation signupOrganisation = signupService.getSignupDAO().getSignupOrganisation(context);
                request.setAttribute("signupOrganisation", (Object)signupOrganisation);
            }
            if ((registerForm = (DynaActionForm)form).get("submitted") != null && ((Boolean)registerForm.get("submitted")).booleanValue()) {
                ActionMessages errors = this.validate(registerForm);
                if (!errors.isEmpty()) {
                    this.saveErrors(request, errors);
                    return mapping.findForward("register");
                }
                User user = new User();
                user.setLogin(registerForm.getString("username"));
                user.setFirstName(registerForm.getString("firstName"));
                user.setLastName(registerForm.getString("lastName"));
                user.setEmail(registerForm.getString("email"));
                user.setPassword(HashUtil.sha1((String)registerForm.getString("password")));
                signupService.signupUser(user, registerForm.getString("context"));
                try {
                    String subject = "Your LAMS account details";
                    String body = "Hi there,\n\n";
                    body = body + "You've successfully registered an account with username " + user.getLogin();
                    body = body + " on the LAMS server at " + Configuration.get((String)ConfigurationKeys.SERVER_URL);
                    body = body + ".  If you ever forget your password, you can reset it via this URL " + Configuration.get((String)ConfigurationKeys.SERVER_URL) + "/forgotPassword.jsp.";
                    body = body + "\n\n";
                    body = body + "Regards,\n";
                    body = body + "LAMS Signup System";
                    Emailer.sendFromSupportEmail((String)subject, (String)user.getEmail(), (String)body);
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    request.setAttribute("error", (Object)e.getMessage());
                }
                return mapping.findForward("success");
            }
            return mapping.findForward("register");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            request.setAttribute("error", (Object)e.getMessage());
            return mapping.findForward("index");
        }
    }

    private ActionMessages validate(DynaActionForm registerForm) {
        ActionMessages errors = new ActionMessages();
        if (StringUtils.isBlank((String)registerForm.getString("username"))) {
            errors.add("username", new ActionMessage("error.username.blank"));
        } else if (signupService.getSignupDAO().usernameExists(registerForm.getString("username"))) {
            errors.add("username", new ActionMessage("error.username.exists"));
        }
        if (StringUtils.isBlank((String)registerForm.getString("firstName"))) {
            errors.add("firstName", new ActionMessage("error.first.name.blank"));
        }
        if (StringUtils.isBlank((String)registerForm.getString("lastName"))) {
            errors.add("lastName", new ActionMessage("error.last.name.blank"));
        }
        if (StringUtils.isBlank((String)registerForm.getString("password"))) {
            errors.add("password", new ActionMessage("error.password.blank"));
        } else if (!StringUtils.equals((String)registerForm.getString("password"), (String)registerForm.getString("confirmPassword"))) {
            errors.add("password", new ActionMessage("error.passwords.unequal"));
        }
        if (StringUtils.isBlank((String)registerForm.getString("email"))) {
            errors.add("email", new ActionMessage("error.email.blank"));
        } else {
            Pattern p;
            Matcher m;
            if (!StringUtils.equals((String)registerForm.getString("email"), (String)registerForm.getString("confirmEmail"))) {
                errors.add("email", new ActionMessage("error.emails.unequal"));
            }
            if (!(m = (p = Pattern.compile(".+@.+\\.[a-z]+")).matcher(registerForm.getString("email"))).matches()) {
                errors.add("email", new ActionMessage("error.email.invalid.format"));
            }
        }
        if (!signupService.getSignupDAO().courseKeyIsValid(registerForm.getString("context"), registerForm.getString("courseKey"))) {
            errors.add("courseKey", new ActionMessage("error.course.key.invalid"));
        }
        return errors;
    }
}

