/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: TestBehaviourComposerReportDAO.java,v 1.5 2006/04/06 06:41:33 fmalikoff Exp $$ */	

package org.lamsfoundation.lams.tool.behaviourComposer.dao;

import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerBaseTestCase;
import org.lamsfoundation.lams.tool.behaviourComposer.SubmissionDetails;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerContent;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerReport;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerSession;
import org.lamsfoundation.lams.tool.behaviourComposer.dao.hibernate.BehaviourComposerContentDAO;
import org.lamsfoundation.lams.tool.behaviourComposer.dao.hibernate.BehaviourComposerReportDAO;

/**
 * @author Manpreet Minhas
 */
public class TestBehaviourComposerReportDAO extends BehaviourComposerBaseTestCase {
	
	protected BehaviourComposerReport behaviourComposerReport;
	protected BehaviourComposerContent behaviourComposerContent;
	protected IBehaviourComposerContentDAO behaviourComposerContentDAO;
	protected IBehaviourComposerReportDAO behaviourComposerReportDAO;
	protected ISubmissionDetailsDAO submissionDetailsDAO;
	
	public TestBehaviourComposerReportDAO(String name){
		super(name);
	}
	
	public void setUp()throws Exception{
		super.setUp();
		behaviourComposerReportDAO = (BehaviourComposerReportDAO)context.getBean("behaviourComposerReportDAO");
		behaviourComposerContentDAO = (BehaviourComposerContentDAO)context.getBean("behaviourComposerContentDAO");
		submissionDetailsDAO = (ISubmissionDetailsDAO)context.getBean("submissionDetailsDAO");
	}
	
	public void testGetReportByID() {
		BehaviourComposerReport report = behaviourComposerReportDAO.getReportByID(TEST_REPORT_ID);
		assertNotNull("report",report);
		assertEquals(report.getComments(),TEST_REPORT_COMMENT);
	}
	public void testAddBehaviourComposerReport(){

		SubmissionDetails details = submissionDetailsDAO.getSubmissionDetailsByID(TEST_SUBMISSION_ID);
		assertNotNull("details", details);

		behaviourComposerReport = details.getReport();
		assertNotNull("behaviourComposerReport", behaviourComposerReport);

		BehaviourComposerReport clone = (BehaviourComposerReport) behaviourComposerReport.clone();
		behaviourComposerReportDAO.insert(clone);
		assertNotNull(clone.getReportID());
		assertNotSame("Clone has a different id", clone.getReportID(), behaviourComposerReport.getReportID());

	}	
}
