/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: SubmissionDetails.java,v 1.12 2006/04/06 06:41:34 fmalikoff Exp $$ */	
package org.lamsfoundation.lams.tool.behaviourComposer;

import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;


/**
 * @hibernate.class table="tl_kkbc10_submission_details"
 * @serial 5093528405144051727L
 */
public class SubmissionDetails implements Serializable,Cloneable{

	private static final long serialVersionUID = 5093528405144051727L;

	private static Logger log = Logger.getLogger(SubmissionDetails.class);
	
	/** identifier field */
	private Long submissionID;

	/** persistent field */
	private String filePath;

	/** persistent field */
	private String fileDescription;

	/** persistent field */
	private Date dateOfSubmission;

	/** persistent field */
	private Long uuid;

	/** persistent field */
	private Long versionID;

	
	/** persistent field */
	private BehaviourComposerReport report;

	private Learner learner;
	
	/** persistent field, but not cloned to avoid to clone block*/
	private BehaviourComposerSession behaviourComposerFileSession;
	
	/** default constructor */
	public SubmissionDetails() {
	}
	/**
	 * @hibernate.id generator-class="identity" type="java.lang.Long"
	 *               column="submission_id"
	 */
	public Long getSubmissionID() {
		return this.submissionID;
	}

	public void setSubmissionID(Long submissionID) {
		this.submissionID = submissionID;
	}

	/**
	 * @hibernate.property column="filePath" length="250"
	 */
	public String getFilePath() {
		return this.filePath;
	}

	public void setFilePath(String filePath) {
		this.filePath = filePath;
	}

	/**
	 * @hibernate.property column="fileDescription" length="250"
	 */
	public String getFileDescription() {
		return this.fileDescription;
	}

	public void setFileDescription(String fileDescription) {
		this.fileDescription = fileDescription;
	}

	/**
	 * @hibernate.property column="date_of_submission" length="19"
	 */
	public Date getDateOfSubmission() {
		return this.dateOfSubmission;
	}

	public void setDateOfSubmission(Date dateOfSubmission) {
		this.dateOfSubmission = dateOfSubmission;
	}

	/**
	 * @hibernate.property column="uuid" length="20"
	 */
	public Long getUuid() {
		return this.uuid;
	}

	public void setUuid(Long uuid) {
		this.uuid = uuid;
	}

	/**
	 * @hibernate.property column="version_id" length="20"
	 */
	public Long getVersionID() {
		return this.versionID;
	}

	public void setVersionID(Long versionID) {
		this.versionID = versionID;
	}

	public String toString() {
		return new ToStringBuilder(this)
				.append("submissionID",getSubmissionID()).append("filePath", getFilePath())
				.append("fileDescription", getFileDescription())
				.append("dateOfSubmission", getDateOfSubmission())
				.append("uuid",getUuid())
				.append("versionID", getVersionID())
				.append("report",getReport())
				.toString();
	}

	public boolean equals(Object other) {
		if ((this == other))
			return true;
		if (!(other instanceof SubmissionDetails))
			return false;
		SubmissionDetails castOther = (SubmissionDetails) other;
		return new EqualsBuilder().append(this.getSubmissionID(),
				castOther.getSubmissionID()).append(this.getFilePath(),
				castOther.getFilePath()).append(this.getFileDescription(),
				castOther.getFileDescription()).append(
				this.getDateOfSubmission(), castOther.getDateOfSubmission())
				.append(this.getUuid(), castOther.getUuid())
				.append(this.getVersionID(), castOther.getVersionID())				
				.append(this.getReport(),castOther.getReport())
				.isEquals();
	}

	public int hashCode() {
		return new HashCodeBuilder().append(getSubmissionID()).append(
				getFilePath()).append(getFileDescription()).append(
				getDateOfSubmission()).append(getUuid()).append(getVersionID())
				.append(getReport()).toHashCode();
	}

	/**
	 * @hibernate.one-to-one  cascade="all" not-null="false"
	 * foreign-key="report_id"
	 * @return Returns the report.
	 */
	public BehaviourComposerReport getReport() {
		return report;
	}
	/**
	 * @param report
	 *            The report to set.
	 */
	public void setReport(BehaviourComposerReport report) {
		this.report = report;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#clone()
	 */
	public Object clone()  {
		Object obj = null;
		try {
			obj = super.clone();
			//never clone key!
			((SubmissionDetails)obj).setSubmissionID(null);
			if(this.report != null)
				((SubmissionDetails)obj).report = (BehaviourComposerReport) this.report.clone();
		} catch (CloneNotSupportedException e) {
			log.error("When clone " + SubmissionDetails.class + " failed");
		}
		return obj;
	}

	/**
	 * @hibernate.many-to-one column="session_id" cascade="save-update" 
	 * @return Returns the behaviourComposerFileSession.
	 */
	public BehaviourComposerSession getBehaviourComposerFileSession() {
		return behaviourComposerFileSession;
	}
	/**
	 * @param behaviourComposerFileSession The behaviourComposerFileSession to set.
	 */
	public void setBehaviourComposerFileSession(BehaviourComposerSession behaviourComposerFileSession) {
		this.behaviourComposerFileSession = behaviourComposerFileSession;
	}
	/**
	/**
	 * @hibernate.many-to-one column="learner_id" cascade="save-update"
	 * @return Returns the learner.
	 */
	public Learner getLearner() {
		return learner;
	}
	/**
	 * @param learner The learner to set.
	 */
	public void setLearner(Learner learner) {
		this.learner = learner;
	}

}
