/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: IBehaviourComposerContentDAO.java,v 1.6 2006/04/06 06:41:33 fmalikoff Exp $$ */	

package org.lamsfoundation.lams.tool.behaviourComposer.dao;

import org.lamsfoundation.lams.dao.IBaseDAO;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerContent;

/**
 * @author Manpreet Minhas
 */
public interface IBehaviourComposerContentDAO extends IBaseDAO{
	
	/**
	 * Returns the content corresponding to the given
	 * <code>contentID</code>
	 * 
	 * @param contentID The contentID to be looked up
	 * @return BehaviourComposerContent The required populated object
	 */
	public BehaviourComposerContent getContentByID(Long contentID);

	/**
	 * Save the given content. If the content existed, then update the old
	 * content by new given content.
	 *  
	 * @param content
	 */
	public void saveOrUpdate(BehaviourComposerContent content);

	public void deleteInstructionFile(Long contentID, Long uuid, Long versionID, String type);	
	
}
