/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: BehaviourComposerSessionDAO.java,v 1.6 2006/04/06 06:41:33 fmalikoff Exp $$ */	

package org.lamsfoundation.lams.tool.behaviourComposer.dao.hibernate;

import java.util.List;

import org.lamsfoundation.lams.dao.hibernate.BaseDAO;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerSession;
import org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerSessionDAO;

/**
 * @author Manpreet Minhas
 */
public class BehaviourComposerSessionDAO extends BaseDAO implements
		IBehaviourComposerSessionDAO {

    private static final String FIND_LEARNER_BY_CONTENT_ID = 
        " from BehaviourComposerSession session " +
        " where session.content.contentID = :contentID";

    
	/**
	 * (non-Javadoc)
	 * @see org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerSessionDAO#getSessionByID(java.lang.Long)
	 */
	public BehaviourComposerSession getSessionByID(Long sessionID) {		
		 return (BehaviourComposerSession) super.find(BehaviourComposerSession.class,sessionID);
	}

	/* (non-Javadoc)
	 * @see org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerSessionDAO#createSession(org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerSession)
	 */
	public void createSession(BehaviourComposerSession behaviourComposerSession) {
		 this.getHibernateTemplate().save(behaviourComposerSession);
		 this.getHibernateTemplate().flush();
	}
    
    public List getBehaviourComposerSessionByContentID(Long contentID){
        if ( contentID != null ) {
            return this.getSession().createQuery(FIND_LEARNER_BY_CONTENT_ID)
                .setLong("contentID", contentID.longValue())
                .list();
        }
        return null;
    }

}
