/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: BehaviourComposerException.java,v 1.4 2006/04/06 06:41:34 fmalikoff Exp $$ */	

package org.lamsfoundation.lams.tool.behaviourComposer.exception;

/**
 * @author Manpreet Minhas
 */
public class BehaviourComposerException extends RuntimeException {

	private static final long serialVersionUID = 8623508856810983309L;

	/**
     * Default Constructor
     */
    public BehaviourComposerException()
    {
        super();
    }

    /**
     * Constructor for customized error message
     * @param message
     */
    public BehaviourComposerException(String message)
    {
        super(message);
    }

    /**
     * Constructor for wrapping the throwable object
     * @param cause
     */
    public BehaviourComposerException(Throwable cause)
    {
        super(cause);
    }

    /**
     * Constructor for wrapping both the customized error message and 
     * throwable exception object.
     * @param message
     * @param cause
     */
    public BehaviourComposerException(String message, Throwable cause)
    {
        super(message, cause);
    }

}
