/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: TestBehaviourComposerService.java,v 1.7 2006/04/06 06:41:33 fmalikoff Exp $$ */	

package org.lamsfoundation.lams.tool.behaviourComposer.service;

import org.lamsfoundation.lams.tool.ToolContentManager;
import org.lamsfoundation.lams.tool.ToolSessionManager;
import org.lamsfoundation.lams.tool.exception.SessionDataExistsException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerBaseTestCase;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerContent;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerSession;
import org.lamsfoundation.lams.tool.behaviourComposer.dao.ISubmissionDetailsDAO;
import org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerContentDAO;
import org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerSessionDAO;

/**
 * Note: this test sets up tool content ids and tool session ids that 
 * are invalid with respect to the core tables.
 * 
 * @author Manpreet Minhas, Fiona Malikoff
 */
public class TestBehaviourComposerService extends BehaviourComposerBaseTestCase {
	
	protected IBehaviourComposerService behaviourComposerService;
	protected ToolContentManager behaviourComposerToolContentManager;
	protected ToolSessionManager behaviourComposerToolSessionManager;
	
	protected IBehaviourComposerSessionDAO behaviourComposerSessionDAO  = null;
	protected IBehaviourComposerContentDAO behaviourComposerContentDAO  = null;
	protected ISubmissionDetailsDAO submissionDetailsDAO;
	
	protected BehaviourComposerContent behaviourComposerContent;
	
	public TestBehaviourComposerService(String name){
		super(name);
	}

	public void setUp()throws Exception{
		super.setUp();
		behaviourComposerService = (IBehaviourComposerService)context.getBean("behaviourComposerService");
		behaviourComposerToolContentManager = (ToolContentManager) behaviourComposerService;
		behaviourComposerToolSessionManager = (ToolSessionManager) behaviourComposerService;

		behaviourComposerSessionDAO = (IBehaviourComposerSessionDAO)context.getBean("behaviourComposerSessionDAO");
		behaviourComposerContentDAO = (IBehaviourComposerContentDAO)context.getBean("behaviourComposerContentDAO");
	}
	/*public void testAddBehaviourComposerContent(){
		behaviourComposerService.addBehaviourComposerContent(new Long(1),"Trial Title BehaviourComposer Files", "Trial Instructions BehaviourComposer Files");
		assertNotNull(behaviourComposerContentDAO.getContentByID(new Long(1)));
	}
	public void testUploadFile(){
		String filePath = "c:" + File.separator + "mminhas.txt";
		behaviourComposerService.uploadFile(new Long(1),filePath,"Trial Content File Description", new Long(1));
		behaviourComposerService.uploadFile(new Long(1),filePath,"Trial Content File Description", new Long(1));
		behaviourComposerService.uploadFile(new Long(1),filePath,"Trial Content File Description", new Long(2));
		behaviourComposerService.uploadFile(new Long(1),filePath,"Trial Content File Description", new Long(3));
		behaviourComposerService.uploadFile(new Long(1),filePath,"Trial Content File Description", new Long(1));
		behaviourComposerService.uploadFile(new Long(1),filePath,"Trial Content File Description", new Long(2));
		assertNotNull(submissionDetailsDAO.getSubmissionDetailsByID(new Long(1)));
	}*/
	
	public void testCopyContent(){
		Long id = copyTestContent();
	}
	
	private Long copyTestContent() {
		
		Long newContentId = new Long(getMaxContentId() + 1);
		try {
			behaviourComposerToolContentManager.copyToolContent(TEST_CONTENT_ID, newContentId);
		} catch (ToolException e) {
			e.printStackTrace();
			fail("Tool exception thrown copying the content");
		}
		return newContentId;
	}

	public void testCreateSession() {
		createSession(copyTestContent());
	}
	
	private BehaviourComposerSession createSession(Long toolContentId) {
		Long toolSessionId = new Long(getMaxSessionId()+1);

		try {
			behaviourComposerToolSessionManager.createToolSession(toolSessionId,"sessionName",toolContentId);
		} catch (ToolException e) {
			e.printStackTrace();
			fail("Tool exception thrown while creating session");
		}
		BehaviourComposerSession behaviourComposerSession = behaviourComposerSessionDAO.getSessionByID(toolSessionId);
		assertNotNull("behaviourComposerSession", behaviourComposerSession);
		assertEquals(toolSessionId, behaviourComposerSession.getSessionID());
		return behaviourComposerSession;
	}
	
	/** Tests removing content where session data exists */ 
	public void testRemoveToolContentSessionDataExists(){
		
		Long toolContentId = copyTestContent();
		BehaviourComposerSession behaviourComposerSession = createSession(toolContentId);
		Long sessionContentId = behaviourComposerSession.getSessionID();

		// Remove without removing the session data - should fail. 
		try {
			behaviourComposerToolContentManager.removeToolContent(toolContentId, false);
			fail("Expected SessionDataExistsException to be thrown, toolSessionId = "
					+sessionContentId);
		} catch (SessionDataExistsException e) {
			assertTrue("SessionDataExistsException thrown as expected", true);
		} catch (ToolException e) {
			e.printStackTrace();
			fail("Tool exception thrown deleting the content toolContentId="+toolContentId);
		}

		// Records should still exist
		BehaviourComposerContent content = behaviourComposerContentDAO.getContentByID(toolContentId);
		assertNotNull("Tool content data", content);

		BehaviourComposerSession session = behaviourComposerSessionDAO.getSessionByID(sessionContentId);
		assertNotNull("Tool session data", session);

		// This time remove the session data too! 
		try {
			behaviourComposerToolContentManager.removeToolContent(toolContentId, true);
		} catch (SessionDataExistsException e) {
			e.printStackTrace();
			fail("SessionDataExistsException thrown deleting the content toolContentId="+toolContentId);
		} catch (ToolException e) {
			e.printStackTrace();
			fail("Tool exception thrown deleting the content toolContentId="+toolContentId);
		}

		BehaviourComposerContent content2 = behaviourComposerContentDAO.getContentByID(toolContentId);
		assertNull("Tool Content has been deleted as expected", content2);

		BehaviourComposerSession session2 = behaviourComposerSessionDAO.getSessionByID(sessionContentId);
		assertNull("Tool session has been deleted as expected", session2);
		
	}

	/** Tests removing content where session data does not exist */ 
	public void testRemoveToolContentNoSessionData(){
		
		Long toolContentId = copyTestContent();

		// Remove without removing the session data - should work. 
		try {
			behaviourComposerToolContentManager.removeToolContent(toolContentId, true);
		} catch (SessionDataExistsException e) {
			e.printStackTrace();
			fail("SessionDataExistsException thrown deleting the content toolContentId="+toolContentId);
		} catch (ToolException e) {
			e.printStackTrace();
			fail("Tool exception thrown deleting the content toolContentId="+toolContentId);
		}

		BehaviourComposerContent content2 = behaviourComposerContentDAO.getContentByID(toolContentId);
		assertNull("Tool Content has been deleted as expected", content2);

	}

	/*	public void testGenerateReport(){
		Hashtable table = behaviourComposerService.generateReport(new Long(1));
		assertEquals(table.size(),3);
	}*/

}
 
