/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: BehaviourComposerContentDAO.java,v 1.10 2006/04/06 06:41:33 fmalikoff Exp $$ */	

package org.lamsfoundation.lams.tool.behaviourComposer.dao.hibernate;

import java.util.List;

import org.hibernate.FlushMode;
import org.lamsfoundation.lams.dao.hibernate.BaseDAO;
import org.lamsfoundation.lams.tool.behaviourComposer.InstructionFiles;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerContent;
import org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerContentDAO;
import org.springframework.orm.hibernate3.HibernateTemplate;

/**
 * @author Manpreet Minhas
 */
public class BehaviourComposerContentDAO extends BaseDAO implements IBehaviourComposerContentDAO {

	private static final String FIND_INSTRUCTION_FILE = "from " + InstructionFiles.class.getName() 
													+ " as i where content_id=? and i.uuID=? and i.versionID=? and i.type=?";
	/**
	 * (non-Javadoc)
	 * @see org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerContentDAO#getContentByID(java.lang.Long)
	 */
	public BehaviourComposerContent getContentByID(Long contentID) {
		return (BehaviourComposerContent) super.find(BehaviourComposerContent.class,contentID);
	}

	/* (non-Javadoc)
	 * @see org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerContentDAO#save(org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerContent)
	 */
	public void saveOrUpdate(BehaviourComposerContent content) {
		this.getSession().setFlushMode(FlushMode.COMMIT);
		this.getHibernateTemplate().saveOrUpdate(content);
		this.getHibernateTemplate().flush();
	}

	public void deleteInstructionFile(Long contentID, Long uuid, Long versionID, String type) {
		HibernateTemplate templ = this.getHibernateTemplate();
		if ( contentID != null && uuid != null && versionID != null ) {
			List list = getSession().createQuery(FIND_INSTRUCTION_FILE)
				.setLong(0,contentID.longValue())
				.setLong(1,uuid.longValue())
				.setLong(2,versionID.longValue())
				.setString(3,type)
				.list();
			if(list != null && list.size() > 0){
				InstructionFiles file = (InstructionFiles) list.get(0);
				this.getSession().setFlushMode(FlushMode.AUTO);
				templ.delete(file);
				templ.flush();
			}
		}
		
	}
		
}
