/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: BehaviourComposerSession.java,v 1.15 2006/04/06 06:41:34 fmalikoff Exp $$ */	
package org.lamsfoundation.lams.tool.behaviourComposer;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;


/** 
 * @hibernate.class table="tl_kkbc10_session"
 * @serial 3399851325547422573L
*/
public class BehaviourComposerSession implements Serializable,Cloneable{

	private static final long serialVersionUID = 3399851325547422573L;

	private static Logger log = Logger.getLogger(BehaviourComposerSession.class);
	
    public final static int INCOMPLETE = 0;
    public final static int COMPLETED = 1;
    
	/** identifier field */
    private Long sessionID;
    
    /** persistent field */
    private String sessionName;

    /** persistent field */
    private Integer status;
	
	/** persistent field */
	private Set bcSubmissionDetails;

	/** persistent field */
	private Set learners;

	/** persistent field, but not cloned to avoid to clone block*/
	private BehaviourComposerContent content;
	
    /** full constructor */
    public BehaviourComposerSession(Long sessionID,int status) {
    	this.sessionID = sessionID;
        this.status = new Integer(status);
    }

    /** default constructor */
    public BehaviourComposerSession() {
    }

    /** 
     * @hibernate.id generator-class="assigned" type="java.lang.Long" column="session_id"
     */
    public Long getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(Long sessionID) {
        this.sessionID = sessionID;
    }

    /** 
     * @hibernate.property column="status" length="11" not-null="true" 
     */
    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }


    public String toString() {
        return new ToStringBuilder(this)
            .append("sessionID", getSessionID())
            .append("status", getStatus())
            .toString();
    }

    public boolean equals(Object other) {
        if ( (this == other ) ) return true;
        if ( !(other instanceof BehaviourComposerSession) ) return false;
        BehaviourComposerSession castOther = (BehaviourComposerSession) other;
        return new EqualsBuilder()
            .append(this.getSessionID(), castOther.getSessionID())
            .append(this.getStatus(), castOther.getStatus())
            .isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder()
            .append(getSessionID())
            .append(getStatus())
            .toHashCode();
    }

	/* (non-Javadoc)
	 * @see java.lang.Object#clone()
	 */
	public Object clone()  {
		Object obj = null;
		try {
			obj = super.clone();
			//never clone key!
			((BehaviourComposerSession)obj).setSessionID(null);
			//clone SubmissionDetails object
			if(bcSubmissionDetails != null){
				Iterator iter = bcSubmissionDetails.iterator();
				Set set = new HashSet();
				while(iter.hasNext())
					set.add(((BCSubmissionDetails)iter.next()).clone());
				((BehaviourComposerSession)obj).bcSubmissionDetails = set;
			}
			
		} catch (CloneNotSupportedException e) {
			log.error("When clone " + BCSubmissionDetails.class + " failed");
		}
		return obj;
	}
	/**
	 * @hibernate.set lazy="true" inverse="true" cascade="all-delete-orphan"
	 * @hibernate.collection-one-to-many 
	 * class="org.lamsfoundation.lams.tool.behaviourComposer.BCSubmissionDetails"
	 * @hibernate.collection-key column="session_id"
	 * @return Returns the submissionDetails.
	 */
	public Set getBcSubmissionDetails() {
		return bcSubmissionDetails;
	}
	/**
	 * @param submissionDetails The submissionDetails to set.
	 */
	public void setBcSubmissionDetails(Set bcSubmissionDetails) {
		this.bcSubmissionDetails = bcSubmissionDetails;
	}
	/**
	 * @hibernate.set lazy="true" inverse="true" cascade="all-delete-orphan"
	 * @hibernate.collection-one-to-many 
	 * class="org.lamsfoundation.lams.tool.behaviourComposer.Learner"
	 * @hibernate.collection-key column="session_id"
	 * 
	 * @return Returns the learners.
	 */
	public Set getLearners() {
		return learners;
	}
	/**
	 * @param bCSubmissionDetails The submissionDetails to set.
	 */
	public void setLearners(Set learners) {
		this.learners = learners;
	}
	/**
	 * @hibernate.many-to-one column="content_id" cascade="none"
	 * 
	 * @return Returns the content.
	 */
	public BehaviourComposerContent getContent() {
		return content;
	}
	/**
	 * @param content The content to set.
	 */
	public void setContent(BehaviourComposerContent content) {
		this.content = content;
	}
	
	/**
	 * @hibernate.property column="session_name" length="250"
	 * 
	 * @return Returns the session name.
	 */
	public String getSessionName() {
		return sessionName;
	}

	/**
	 * 
	 * @param sessionName The session name to set.
	 */
	public void setSessionName(String sessionName) {
		this.sessionName = sessionName;
	}
}
