/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: FileDetailsDTO.java,v 1.11 2006/08/23 05:42:37 steven Exp $$ */	

package org.lamsfoundation.lams.tool.behaviourComposer.dto;

import java.io.Serializable;
import java.util.Date;

import org.apache.log4j.Logger;
import org.lamsfoundation.lams.tool.behaviourComposer.Learner;
import org.lamsfoundation.lams.tool.behaviourComposer.BCSubmissionDetails;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerReport;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;

/**
 * @author Manpreet Minhas
 */
public class FileDetailsDTO implements Serializable{

	private Logger log = Logger.getLogger(FileDetailsDTO.class);
	private static final long serialVersionUID = 2964711101016972263L;
	private Long userID;
	private Long submissionID;
	private Long reportID;
	private String filePath;
	private String fileDescription;
	private Date dateOfSubmission;
	private Date dateMarksReleased;
	private boolean finished;
	private String comments;	
	private String marks;
	private Long uuID;
	private Long versionID;
	private String exportedURL;  // the location of this file saved by the export function.      	
	private UserDTO userDTO;
	

	public FileDetailsDTO(BCSubmissionDetails details, UserDTO userDTO){
		if(details == null){
			log.warn("SubmissionDetails is null, failed to initial FileDetailDTO");
			return;
		}
		
		Learner learner = details.getLearner();
		if(learner != null){
			this.userID = learner.getUserID();
			this.finished = learner.isFinished();
		}
		
		this.submissionID = details.getSubmissionID();
		this.filePath = details.getFilePath();
		this.fileDescription = details.getFileDescription();
		this.dateOfSubmission = details.getDateOfSubmission();
		this.uuID = details.getUuid();
		this.versionID = details.getVersionID();
		BehaviourComposerReport report = details.getReport();
		if(report != null){
			this.reportID = report.getReportID();
			this.dateMarksReleased = report.getDateMarksReleased();		
			this.comments = report.getComments();
			this.marks = report.getMarks() != null? report.getMarks().toString():"";
		}
		this.userDTO = userDTO;
	}

	public String getExportedURL() {
		return exportedURL;
	}
	public void setExportedURL(String exportedURL) {
		this.exportedURL = exportedURL;
	}

	/**
	 * @return Returns the reportID.
	 */
	public Long getReportID() {
		return reportID;
	}
	/**
	 * @param reportID The reportID to set.
	 */
	public void setReportID(Long reportID) {
		this.reportID = reportID;
	}
	/**
	 * @return Returns the comments.
	 */
	public String getComments() {		
		return comments;
	}
	/**
	 * @param comments The comments to set.
	 */
	public void setComments(String comments) {
		this.comments = comments;
	}
	/**
	 * @return Returns the dateOfSubmission.
	 */
	public Date getDateOfSubmission() {
		return dateOfSubmission;
	}
	/**
	 * @param dateOfSubmission The dateOfSubmission to set.
	 */
	public void setDateOfSubmission(Date dateOfSubmission) {
		this.dateOfSubmission = dateOfSubmission;
	}
	/**
	 * @return Returns the fileDescription.
	 */
	public String getFileDescription() {
		return fileDescription;
	}
	/**
	 * @param fileDescription The fileDescription to set.
	 */
	public void setFileDescription(String fileDescription) {
		this.fileDescription = fileDescription;
	}
	/**
	 * @return Returns the filePath.
	 */
	public String getFilePath() {
		return filePath;
	}
	/**
	 * @param filePath The filePath to set.
	 */
	public void setFilePath(String filePath) {
		this.filePath = filePath;
	}
	/**
	 * @return Returns the marks.
	 */
	public String getMarks() {
		return marks;
	}
	/**
	 * @param marks The marks to set.
	 */
	public void setMarks(String marks) {
		this.marks = marks;
	}	
	
	/**
	 * @return Returns the dateMarksReleased.
	 */
	public Date getDateMarksReleased() {
		return dateMarksReleased;
	}
	/**
	 * @param dateMarksReleased The dateMarksReleased to set.
	 */
	public void setDateMarksReleased(Date dateMarksReleased) {
		this.dateMarksReleased = dateMarksReleased;
	}
	/**
	 * @return Returns the uuID.
	 */
	public Long getUuID() {
		return uuID;
	}
	/**
	 * @param uuID The uuID to set.
	 */
	public void setUuID(Long uuID) {
		this.uuID = uuID;
	}
	/**
	 * @return Returns the versionID.
	 */
	public Long getVersionID() {
		return versionID;
	}
	/**
	 * @param versionID The versionID to set.
	 */
	public void setVersionID(Long versionID) {
		this.versionID = versionID;
	}
	/**
	 * @return Returns the submissionID.
	 */
	public Long getSubmissionID() {
		return submissionID;
	}
	/**
	 * @param submissionID The submissionID to set.
	 */
	public void setSubmissionID(Long submissionID) {
		this.submissionID = submissionID;
	}

	/**
	 * @return Returns the userID.
	 */
	public Long getUserID() {
		return userID;
	}

	/**
	 * @param userID The userID to set.
	 */
	public void setUserID(Long userID) {
		this.userID = userID;
	}

	/**
	 * @return Returns the userDTO.
	 */
	public UserDTO getUserDTO() {
		return userDTO;
	}

	/**
	 * @param userDTO The userDTO to set.
	 */
	public void setUserDTO(UserDTO userDTO) {
		this.userDTO = userDTO;
	}
	/**
	 * @return Returns the finished.
	 */
	public boolean isFinished() {
		return finished;
	}
	/**
	 * @param finished The finished to set.
	 */
	public void setFinished(boolean finished) {
		this.finished = finished;
	}
}
