/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: BehaviourComposerSessionDAO.java,v 1.9 2006/04/06 07:05:07 fmalikoff Exp $$ */
package org.lamsfoundation.lams.tool.behaviourComposer.dao.hibernate;

import java.util.List;

import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerContent;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerSession;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerUser;
import org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerSessionDAO;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

/**
 * @author mtruong
 * <p>Hibernate implementation for database access to BehaviourComposer sessions for the behaviourComposer tool.</p>
 */

public class BehaviourComposerSessionDAO extends HibernateDaoSupport implements IBehaviourComposerSessionDAO {
	
	private static final String FIND_NB_SESSION = "from " + BehaviourComposerSession.class.getName() + " as behaviourComposer where behaviourComposer.behaviourComposerSessionId=?";
	
    private static final String LOAD_NBSESSION_BY_USER = "select ns from BehaviourComposerSession ns left join fetch "
        + "ns.behaviourComposerUsers user where user.userId=:userId";
    
    private static final String GET_SESSIONS_FROM_CONTENT = "select ns.behaviourComposerSessionId from BehaviourComposerSession ns where ns.behaviourComposerContent= :behaviourComposerContent";
  
	
    /** @see org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerSessionDAO#findBehaviourComposerSessionById(java.lang.Long) */
    public BehaviourComposerSession findBehaviourComposerSessionById(Long behaviourComposerSessionId)
	{
	    String query = "from BehaviourComposerSession behaviourComposerS where behaviourComposerS.behaviourComposerSessionId=?";
	    List session = getHibernateTemplate().find(query,behaviourComposerSessionId);
		
		if(session!=null && session.size() == 0)
		{			
			return null;
		}
		else
		{
			return (BehaviourComposerSession)session.get(0);
		}
	}
	
    /** @see org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerSessionDAO#saveBehaviourComposerSession(org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerSession) */
    public void saveBehaviourComposerSession(BehaviourComposerSession behaviourComposerSession)
    {
    	this.getHibernateTemplate().save(behaviourComposerSession);
    }
    
	
    /** @see org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerSessionDAO#updateBehaviourComposerSession(org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerSession) */
    public void updateBehaviourComposerSession(BehaviourComposerSession behaviourComposerSession)
    {
    	this.getHibernateTemplate().update(behaviourComposerSession);
    }

 
    /** @see org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerSessionDAO#removeBehaviourComposerSession(java.lang.Long) */
    public void removeBehaviourComposerSession(Long behaviourComposerSessionId)
    {
       
    	HibernateTemplate templ = this.getHibernateTemplate();
		if ( behaviourComposerSessionId != null) {
			//String query = "from org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerContent as behaviourComposer where behaviourComposer.behaviourComposerContentId=?";
			List list = getSession().createQuery(FIND_NB_SESSION)
				.setLong(0,behaviourComposerSessionId.longValue())
				.list();
			
			if(list != null && list.size() > 0){
				BehaviourComposerSession behaviourComposer = (BehaviourComposerSession) list.get(0);
				this.getSession().setFlushMode(FlushMode.AUTO);
				templ.delete(behaviourComposer);
				templ.flush();
			}
		}
      
    }
    
    /** @see org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerSessionDAO#removeBehaviourComposerSession(org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerSession) */
    public void removeBehaviourComposerSession(BehaviourComposerSession behaviourComposerSession)
    {
    	removeBehaviourComposerSession(behaviourComposerSession.getBehaviourComposerSessionId());
        //this.getHibernateTemplate().delete(behaviourComposerSession);
    }

    
    /** @see org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerSessionDAO#getBehaviourComposerSessionByUser(java.lang.Long) */
    public BehaviourComposerSession getBehaviourComposerSessionByUser(final Long userId)
	{
		 return (BehaviourComposerSession) getHibernateTemplate().execute(new HibernateCallback()
                {

                    public Object doInHibernate(Session session) throws HibernateException
                    {
                        return session.createQuery(LOAD_NBSESSION_BY_USER)
                                      .setLong("userId",
                                      		userId.longValue())
                                      .uniqueResult();
                    }
                });
	}
	
	 
    /** @see org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerSessionDAO#removeBehaviourComposerUsers(org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerSession) */
    public void removeBehaviourComposerUsers(BehaviourComposerSession behaviourComposerSession)
    {
    	this.getHibernateTemplate().deleteAll(behaviourComposerSession.getBehaviourComposerUsers());
    }
	
    
    /** @see org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerSessionDAO#addBehaviourComposerUsers(java.lang.Long, org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerSession) */
    public void addBehaviourComposerUsers(Long behaviourComposerSessionId, BehaviourComposerUser user)
	{
	    BehaviourComposerSession session = findBehaviourComposerSessionById(behaviourComposerSessionId);
	    user.setBehaviourComposerSession(session);
	    session.getBehaviourComposerUsers().add(user);
	    this.getHibernateTemplate().saveOrUpdate(user);
	    this.getHibernateTemplate().merge(session);	    
	}
	
    /** @see org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerSessionDAO#getSessionsFromContent(org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerSession) */
	public List getSessionsFromContent(BehaviourComposerContent behaviourComposerContent)
	{
	    return (getHibernateTemplate().findByNamedParam(GET_SESSIONS_FROM_CONTENT,
	            "behaviourComposerContent",
				behaviourComposerContent));
	}
    	
}
