/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: BehaviourComposerAuthoringAction.java,v 1.31 2006/09/07 00:18:32 fmalikoff Exp $$ */
package org.lamsfoundation.lams.tool.behaviourComposer.web;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.upload.FormFile;
import org.apache.struts.util.MessageResources;
import org.lamsfoundation.lams.authoring.web.AuthoringConstants;
import org.lamsfoundation.lams.contentrepository.InvalidParameterException;
import org.lamsfoundation.lams.contentrepository.NodeKey;
import org.lamsfoundation.lams.contentrepository.RepositoryCheckedException;
import org.lamsfoundation.lams.contentrepository.client.IToolContentHandler;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerApplicationException;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerAttachment;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerConstants;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerContent;
import org.lamsfoundation.lams.tool.behaviourComposer.service.IBehaviourComposerService;
import org.lamsfoundation.lams.tool.behaviourComposer.service.BehaviourComposerServiceProxy;
import org.lamsfoundation.lams.tool.behaviourComposer.util.BehaviourComposerWebUtil;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsLookupDispatchAction;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.lamsfoundation.lams.web.util.AttributeNames;
import org.lamsfoundation.lams.web.util.SessionMap;

/**
 * @author mtruong
 * 
 * <p>This class is a simple combination of BehaviourComposerAuthoringStarterAction and BehaviourComposerAuthoringAction.
 * It has been created for the purpose of supporting the new authoring page which is done using 
 * DHTML.</p>
 * 
 * <p>The unspecified method, is the same as the execute method for BehaviourComposerAuthoringStarterAction.
 * It will get called when the method parameter is not specified (that is on first entry
 * into the authoring environment).</p>
 * 
 * <p> The save, upload and delete method is the same as that of BehaviourComposerAuthoringAction, to see its explanation,
 * please see org.lamsfoundation.lams.tool.behaviourComposer.web.BehaviourComposerAuthoringAction </p>
 *
 * ----------------XDoclet Tags--------------------
 * 
 * @struts:action path="/authoring" name="BehaviourComposerAuthoringForm" scope="request"
 * 				  type="org.lamsfoundation.lams.tool.behaviourComposer.web.BehaviourComposerAuthoringAction"
 *                parameter="method" validate="true" input="/author_page.jsp"
 *
 * @struts:action-forward name="authoringContent" path="/authoring/authoring.jsp"
 * @struts:action-forward name="displayMessage" path=".message"
 * 
 * ----------------XDoclet Tags--------------------
 */

public class BehaviourComposerAuthoringAction extends LamsLookupDispatchAction {
    static Logger logger = Logger.getLogger(BehaviourComposerAuthoringAction.class.getName());
    public final static String FORM="BehaviourComposerAuthoringForm";
    
    /** Get the user from the shared session */
	public UserDTO getUser(HttpServletRequest request) {
		// set up the user details
		HttpSession ss = SessionManager.getSession();
		UserDTO user = (UserDTO) ss.getAttribute(AttributeNames.USER);
		if ( user == null )
		{
		    MessageResources resources = getResources(request);
		    String error = resources.getMessage(BehaviourComposerConstants.ERR_MISSING_PARAM, "User");
		    logger.error(error);
			throw new BehaviourComposerApplicationException(error);
		}
		return user;
	}

    protected Map getKeyMethodMap()
	{
		Map map = new HashMap();
		map.put(BehaviourComposerConstants.BUTTON_SAVE, "save");
		map.put(BehaviourComposerConstants.BUTTON_UPLOAD, "upload");
		map.put(BehaviourComposerConstants.LINK_DELETE, "deleteAttachment");
		
		return map;
	}

    
    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws BehaviourComposerApplicationException {
        
	    //to ensure that we are working with a new form, not one from previous session
		BehaviourComposerAuthoringForm behaviourComposerForm = new BehaviourComposerAuthoringForm();		
		
		Long contentId = WebUtil.readLongParam(request, BehaviourComposerConstants.TOOL_CONTENT_ID);
		String contentFolderId = WebUtil.readStrParam(request, BehaviourComposerConstants.CONTENT_FOLDER_ID);
		
		behaviourComposerForm.setToolContentID(contentId.toString());
		
		/* DefineLater is used in the basic screen. If defineLater is set, then in the authoring page,
		 * the two tabs {Advanced, Instructions} are not visible.
		 */
		behaviourComposerForm.setDefineLater(request.getParameter(BehaviourComposerConstants.DEFINE_LATER));
							
		/*
		 * Retrieve the Service
		 */
		IBehaviourComposerService behaviourComposerService = BehaviourComposerServiceProxy.getBehaviourComposerService(getServlet().getServletContext());
		
		List attachmentList = null;
		if (!contentExists(behaviourComposerService, contentId))
		{
			//	Pre-fill the form with the default content
			//BehaviourComposerContent behaviourComposer =	behaviourComposerService.retrieveBehaviourComposer(BehaviourComposerConstants.DEFAULT_CONTENT_ID);
		    Long defaultToolContentId = behaviourComposerService.getToolDefaultContentIdBySignature(BehaviourComposerConstants.TOOL_SIGNATURE);
		  //  logger.debug("Default tool content id is " + defaultToolContentId);
		    BehaviourComposerContent behaviourComposer = behaviourComposerService.retrieveBehaviourComposer(defaultToolContentId);
			
		    if (behaviourComposer==null)
		    {
		        String error= "There is data missing in the database";
		        logger.error(error);
		        throw new BehaviourComposerApplicationException(error);
		    }
			
			//initialise the values in the form, so the values will be shown in the jsp
			behaviourComposerForm.setToolContentID(contentId.toString());
			behaviourComposerForm.setContentFolderID(contentFolderId);
			behaviourComposerForm.setTitle(behaviourComposer.getTitle());
			behaviourComposerForm.setContent(behaviourComposer.getContent());
			behaviourComposerForm.setOnlineInstructions(behaviourComposer.getOnlineInstructions());
			behaviourComposerForm.setOfflineInstructions(behaviourComposer.getOfflineInstructions());
			
			attachmentList = BehaviourComposerWebUtil.setupAttachmentList(behaviourComposerService,null);
		
		}
		else //content already exists on the database
		{
			//get the values from the database
			BehaviourComposerContent behaviourComposer = behaviourComposerService.retrieveBehaviourComposer(contentId);
			
			/* If retrieving existing content, check whether the contentInUse flag is set, if set, the
			 * author is not allowed to edit content 
			 */
			
			if (BehaviourComposerWebUtil.isContentEditable(behaviourComposer))
			{
			    /* Define later set to true when the edit activity tab is brought up 
			     * So that users cannot start using the content while the staff member is editing the content */
			    behaviourComposerForm.populateFormWithBehaviourComposerContentValues(behaviourComposer);
			    behaviourComposerForm.setContentFolderID(contentFolderId);
			    behaviourComposer.setDefineLater(Boolean.parseBoolean(behaviourComposerForm.getDefineLater()));
			    behaviourComposerService.saveBehaviourComposer(behaviourComposer);
			    
			    /** TODO: setup values in the instructions map */
			 
			}
			else
			{
			    //The contentInUse flag is set and a user has already reached this activity.
			    saveMessages(request, null); //ensure there are no existing messages
			    ActionMessages message = new ActionMessages();
			    message.add(ActionMessages.GLOBAL_MESSAGE, new ActionMessage("message.contentInUseSet"));
			    saveMessages(request, message);
			    return mapping.findForward(BehaviourComposerConstants.DISPLAY_MESSAGE);
			    
			}
			
			//Setup the map containing the files that have been uploaded for this particular tool content id
			attachmentList = BehaviourComposerWebUtil.setupAttachmentList(behaviourComposerService,behaviourComposer);
		
		}
		
		SessionMap map = BehaviourComposerWebUtil.addUploadsToSession(null, request, attachmentList, BehaviourComposerWebUtil.setupDeletedAttachmentList());
		behaviourComposerForm.setSessionMapID(map.getSessionID());
		
		request.setAttribute(FORM, behaviourComposerForm);
		return mapping.findForward(BehaviourComposerConstants.AUTHOR_PAGE);
    }

	/**
	 * Checks the session to see if the title and content session variables exist or not.
	 * 
	 * @param session The HttpSession to check.
	 * @return true if the parameters title and content exists in the session, false otherwise
	 */
	private boolean contentExists(IBehaviourComposerService service, Long id)
	{
		BehaviourComposerContent behaviourComposer = service.retrieveBehaviourComposer(id);
		if (behaviourComposer == null)
			return false;
		else
			return true;
		
	}
	
	public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws BehaviourComposerApplicationException {
			
		BehaviourComposerAuthoringForm behaviourComposerForm = (BehaviourComposerAuthoringForm)form;
		//copyAuthoringFormValuesIntoFormBean(request, behaviourComposerForm);
		
		IBehaviourComposerService behaviourComposerService = BehaviourComposerServiceProxy.getBehaviourComposerService(getServlet().getServletContext());
		String idAsString = behaviourComposerForm.getToolContentID();
		if (idAsString == null)
		{
		    MessageResources resources = getResources(request);
		    String error = resources.getMessage(BehaviourComposerConstants.ERR_MISSING_PARAM, "Tool Content Id");
		    logger.error(error);
			throw new BehaviourComposerApplicationException(error);
		}
		Long content_id = BehaviourComposerWebUtil.convertToLong(behaviourComposerForm.getToolContentID());
		
		//throws exception if the content id does not exist
		checkContentId(content_id);
		
		BehaviourComposerContent behaviourComposerContent = behaviourComposerService.retrieveBehaviourComposer(content_id);
		if ( behaviourComposerContent == null ) {
			//create a new behaviourComposer object 
			behaviourComposerContent = new BehaviourComposerContent();
			behaviourComposerContent.setBehaviourComposerContentId(content_id);
		}
		
		behaviourComposerForm.copyValuesIntoBehaviourComposerContent(behaviourComposerContent);
		if ( behaviourComposerContent.getDateCreated() == null )
			behaviourComposerContent.setDateCreated(behaviourComposerContent.getDateUpdated()); 
		
		UserDTO user = getUser(request);
		behaviourComposerContent.setCreatorUserId(new Long(user.getUserID().longValue()));
		
		// Author has finished editing the content and mark the defineLater flag to false
		behaviourComposerContent.setDefineLater(false);
		behaviourComposerService.saveBehaviourComposer(behaviourComposerContent);
		
		// Save the attachments then update the attachment collections in the session.
		SessionMap sessionMap = getSessionMap(request, behaviourComposerForm);
		List attachmentList = (List) sessionMap.get(BehaviourComposerConstants.ATTACHMENT_LIST);
		List deletedAttachmentList = (List) sessionMap.get(BehaviourComposerConstants.DELETED_ATTACHMENT_LIST);
		deletedAttachmentList = saveAttachments(behaviourComposerService, behaviourComposerContent, attachmentList, deletedAttachmentList, mapping, request);
		sessionMap = BehaviourComposerWebUtil.addUploadsToSession(sessionMap, request, attachmentList, deletedAttachmentList);
	
		request.setAttribute(AuthoringConstants.LAMS_AUTHORING_SUCCESS_FLAG,Boolean.TRUE);		    	
		return mapping.findForward(BehaviourComposerConstants.AUTHOR_PAGE);
		
	}
	  
	/** 
	* Go through the attachments collections. Remove any content repository or tool objects
	* matching entries in the the deletedAttachments collection, add any new attachments in the
	* attachments collection. Clear the deletedAttachments collection, ready for new editing.
	*/ 
  	private List saveAttachments (IBehaviourComposerService behaviourComposerService, BehaviourComposerContent behaviourComposerContent, 
  			List attachmentList, List deletedAttachmentList,
  			ActionMapping mapping, HttpServletRequest request) {

  		if ( deletedAttachmentList != null ) {
  			Iterator iter = deletedAttachmentList.iterator();
  			while (iter.hasNext()) {
				BehaviourComposerAttachment attachment = (BehaviourComposerAttachment) iter.next();
				
		    	try
		    	{
		    	// remove tool entry from db, includies removing entry from the content repository
		    	// deleting a non-existent entry shouldn't cause any errors.
					if ( attachment.getAttachmentId() != null ) {
						behaviourComposerService.removeAttachment(behaviourComposerContent, attachment);
					}
		    	} catch (RepositoryCheckedException e) {
		            logger.error("Unable to delete file",e);
		    		ActionMessages am = new ActionMessages(); 
		    		am.add( ActionMessages.GLOBAL_MESSAGE,  
		    	           new ActionMessage( BehaviourComposerConstants.ERROR_FILE_UPLOAD_CONTENT_REPOSITORY , 
		    	        		   			  attachment.getFilename())); 
		    		saveErrors( request, am );
		    	}
  			}
  			deletedAttachmentList.clear();
  		}
  		
  		if ( attachmentList != null ) {
  			Iterator iter = attachmentList.iterator();
  			while (iter.hasNext()) {
				BehaviourComposerAttachment attachment = (BehaviourComposerAttachment) iter.next();

				if ( attachment.getAttachmentId() == null ) {
					// add entry to tool table - file already in content repository
					behaviourComposerService.saveAttachment(behaviourComposerContent, attachment);
				}
  			}
  		}
  			
  		return deletedAttachmentList;
  	}
	  	
    /**
	 * This method will either upload an online instructions file or an offline instructions file. 
	 * It will upload an online file if the bean property onlineFile is not null and similarly,
	 * will upload an offline file if the bean property offlineFile is not null.
	 * By using the term "upload", we are saving the file information on the local database (?)
	 * 
	 * @param mapping
	 * @param form
	 * @param request
	 * @param response
	 * @return
	 * @throws BehaviourComposerApplicationException
	 */
	public ActionForward upload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response)
		throws InvalidParameterException, FileNotFoundException, RepositoryCheckedException, IOException, BehaviourComposerApplicationException {
	    		
	    
	    	//set up the values in the map
	    	//call the uploadFile method from toolContentHandler
	    	BehaviourComposerAuthoringForm behaviourComposerForm = (BehaviourComposerAuthoringForm)form;
	    	//copyAuthoringFormValuesIntoFormBean(request, behaviourComposerForm);
	    	FormFile theFile;
	    	IBehaviourComposerService behaviourComposerService = BehaviourComposerServiceProxy.getBehaviourComposerService(getServlet().getServletContext());
			
	    	Long content_id = BehaviourComposerWebUtil.convertToLong(behaviourComposerForm.getToolContentID());
			//throws exception if the content id does not exist
			checkContentId(content_id);
			BehaviourComposerContent behaviourComposerContent = behaviourComposerService.retrieveBehaviourComposer(content_id);
	    	
	    	//check if the file uploaded is an online instructions file or offline instructions file.
	    	//if one of the types is null, then the other one must have been uploaded. 
	    	//here we check if the file is an online one
			
			if ((behaviourComposerForm.getOnlineFile() != null && (behaviourComposerForm.getOnlineFile().getFileName().trim().length() != 0)) ||
			        (behaviourComposerForm.getOfflineFile() != null && (behaviourComposerForm.getOfflineFile().getFileName().trim().length() != 0)))
			{
		    	boolean isOnlineFile = ((behaviourComposerForm.getOnlineFile() != null && (behaviourComposerForm.getOnlineFile().getFileName().trim().length() != 0)) ? true: false );
		    	theFile = (isOnlineFile ? behaviourComposerForm.getOnlineFile() : behaviourComposerForm.getOfflineFile());
		    	String fileType = isOnlineFile ? IToolContentHandler.TYPE_ONLINE : IToolContentHandler.TYPE_OFFLINE;

		    	SessionMap map = getSessionMap(request, behaviourComposerForm);
				List attachmentList = (List) map.get(BehaviourComposerConstants.ATTACHMENT_LIST);
		    	List deletedAttachmentList = (List) map.get(BehaviourComposerConstants.DELETED_ATTACHMENT_LIST);
		    	
		    	// if a file with the same name already exists then move the old one to deleted
		    	deletedAttachmentList = moveToDelete(theFile.getFileName(), isOnlineFile, attachmentList, deletedAttachmentList );
		    	
		    	try
		    	{
	    	        // This is a new file and so is saved to the content repository. Add it to the 
		    		// attachments collection, but don't add it to the tool's tables yet.
		    		NodeKey node = behaviourComposerService.uploadFile(theFile.getInputStream(), theFile.getFileName(), theFile.getContentType(), fileType);
	    	        BehaviourComposerAttachment file = new BehaviourComposerAttachment();
		    	    file.setFilename(theFile.getFileName());
		    	   	file.setOnlineFile(isOnlineFile);
			    	file.setBehaviourComposerContent(behaviourComposerContent);
			    	file.setUuid(node.getUuid());
			    	file.setVersionId(node.getVersion()); 
			    	
			    	// add the files to the attachment collection - if one existed, it should have already been removed.
		    	    attachmentList.add(file);
			    	map = BehaviourComposerWebUtil.addUploadsToSession(map, request, attachmentList, deletedAttachmentList);
			    	
			    	//reset the fields so that more files can be uploaded
			    	behaviourComposerForm.setOfflineFile(null);
			    	behaviourComposerForm.setOnlineFile(null);
		    	}
		    	catch (FileNotFoundException e) {
		            logger.error("Unable to uploadfile",e);
		            throw new BehaviourComposerApplicationException("Unable to upload file, exception was "+e.getMessage());
		    	} catch (IOException e) {
		            logger.error("Unable to uploadfile",e);
		            throw new BehaviourComposerApplicationException("Unable to upload file, exception was "+e.getMessage());
		    	} catch (RepositoryCheckedException e) {
		            logger.error("Unable to uploadfile",e);
		            throw new BehaviourComposerApplicationException("Unable to upload file, exception was "+e.getMessage());
		    	}			    	
			}
	  
			behaviourComposerForm.setMethod(BehaviourComposerConstants.INSTRUCTIONS);
			
			return mapping.findForward(BehaviourComposerConstants.AUTHOR_PAGE);
	}
		
		/** If this file exists in attachments list, move it to the deleted attachments list.
		 * Returns the updated deletedAttachments list, creating a new one if needed. Uses the filename 
		 * and isOnline flag to match up the attachment entry */
		private List moveToDelete(String filename, boolean isOnline, List attachmentsList, List deletedAttachmentsList ) {
			return moveToDelete(filename, isOnline, null, attachmentsList, deletedAttachmentsList);
		}
		/** If this file exists in attachments list, move it to the deleted attachments list.
		 * Returns the updated deletedAttachments list, creating a new one if needed. Uses the uuid of the
		 * file to match up the attachment entry */
		private List moveToDelete(Long uuid, List attachmentsList, List deletedAttachmentsList ) {
			return moveToDelete(null, false, uuid, attachmentsList, deletedAttachmentsList);
		}
		
		/** If this file exists in attachments map, move it to the deleted attachments map.
		 * Returns the updated deletedAttachments map, creating a new one if needed. If uuid supplied
		 * then tries to match on that, otherwise uses filename and isOnline. */
		private List moveToDelete(String filename, boolean isOnline, Long uuid, List attachmentsList, List deletedAttachmentsList ) {

			List deletedList = deletedAttachmentsList != null ? deletedAttachmentsList : BehaviourComposerWebUtil.setupDeletedAttachmentList();
			
			if ( attachmentsList != null ) {
				Iterator iter = attachmentsList.iterator();
				BehaviourComposerAttachment attachment = null;
				while ( iter.hasNext() && attachment == null ) {
					BehaviourComposerAttachment value = (BehaviourComposerAttachment) iter.next();
					
					if ( uuid != null ) {
						// compare using uuid
						if ( uuid.equals(value.getUuid()) ) {
							attachment = value;
						}
					} else {
						// compare using filename and online/offline flag
						if ( value.isOnlineFile() == isOnline && value.getFilename().equals(filename) ) {
							attachment = value;
						}
					}
				}
				if ( attachment != null ) {
					deletedList.add(attachment);
					attachmentsList.remove(attachment);
				}
			}
			
			return deletedList;
		}
		
		public ActionForward deleteAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response)
			throws InvalidParameterException, RepositoryCheckedException, BehaviourComposerApplicationException {
		
	    	//set up the values in the map
	    	BehaviourComposerAuthoringForm behaviourComposerForm = (BehaviourComposerAuthoringForm)form;

	    	Long uuid = behaviourComposerForm.getDeleteFileUuid();
	    	if (uuid == null)
	    	{
	    	    String error = "Unable to continue. The file uuid is missing.";
				logger.error(error);
				throw new BehaviourComposerApplicationException(error);
	    	}
	    	
	    	// move the file's details from the attachment collection to the deleted attachments collection
	    	// the attachment will be delete on saving.
		    SessionMap map = getSessionMap(request, behaviourComposerForm);
			List attachmentList = (List) map.get(BehaviourComposerConstants.ATTACHMENT_LIST);
	    	List deletedAttachmentList = (List) map.get(BehaviourComposerConstants.DELETED_ATTACHMENT_LIST);
	    	deletedAttachmentList = moveToDelete(uuid, attachmentList, deletedAttachmentList );
	    	
	    	behaviourComposerForm.setMethod(BehaviourComposerConstants.INSTRUCTIONS);
		
		   	return mapping.findForward(BehaviourComposerConstants.AUTHOR_PAGE);
		}
		

		/**
		 * It is assumed that the contentId is passed as a http parameter
		 * if the contentId is null, an exception is thrown, otherwise proceed as normal
		 * 
		 * @param contentId the <code>toolContentId</code> to check
		 */
		private void checkContentId(Long contentId)
		{
		    if (contentId == null)
			{
				String error = "Unable to continue. Tool content id missing.";
				
				throw new BehaviourComposerApplicationException(error);
			}
		}
		
		/**
		 * Retrieve the SessionMap from the HttpSession.
		 * 
		 * @param request
		 * @param authForm
		 * @return
		 */
		private SessionMap getSessionMap(HttpServletRequest request, BehaviourComposerAuthoringForm behaviourComposerForm) {
			return (SessionMap) request.getSession().getAttribute(behaviourComposerForm.getSessionMapID());
		}
		
		/**
		 * This method copies the values of the request parameters <code>richTextOnlineInstructions</code>
		 * <code>richTextOfflineInstructions</code> <code>richTextContent</code> into the form properties
		 * onlineInstructions, offlineInstructions and content respectively.
		 * 
		 * @param request HttpServlet request
		 * @param form The ActionForm class containing data submitted by the forms.
		 */
	/*	private void copyAuthoringFormValuesIntoFormBean(HttpServletRequest request, BehaviourComposerAuthoringForm form)
		{
		    String onlineInstruction = WebUtil.readStrParam(request, BehaviourComposerConstants.RICH_TEXT_ONLINE_INSTRN, true);
		    String offlineInstruction = WebUtil.readStrParam(request, BehaviourComposerConstants.RICH_TEXT_OFFLINE_INSTRN, true);
		  	String content = WebUtil.readStrParam(request, BehaviourComposerConstants.RICH_TEXT_CONTENT, true);
		  	String title = WebUtil.readStrParam(request, BehaviourComposerConstants.RICH_TEXT_TITLE, true);

		  	
		  	    form.setTitle(title);
		  	
		  	    form.setContent(content);
		  	
		        form.setOnlineInstructions(onlineInstruction);
		  	
		  	    form.setOfflineInstructions(offlineInstruction);
		  
		}  */
		
	/*	private void copyFormValuesIntoBehaviourComposerContent(HttpServletRequest request, BehaviourComposerContent behaviourComposerContent)
		{
		    behaviourComposerContent.setTitle((String)request.getParameter(BehaviourComposerConstants.RICH_TEXT_TITLE));
		    behaviourComposerContent.setContent((String)request.getParameter(BehaviourComposerConstants.RICH_TEXT_CONTENT));
		    behaviourComposerContent.setOnlineInstructions((String)request.getParameter(BehaviourComposerConstants.RICH_TEXT_ONLINE_INSTRN));
		    behaviourComposerContent.setOfflineInstructions((String)request.getParameter(BehaviourComposerConstants.RICH_TEXT_OFFLINE_INSTRN));
		    
		} */
		
}	
	
