/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: BehaviourComposerLearnerAction.java,v 1.16 2006/07/25 04:53:07 steven Exp $$ */
package org.lamsfoundation.lams.tool.behaviourComposer.web;


import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletException;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.lamsfoundation.lams.web.action.LamsLookupDispatchAction;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.lamsfoundation.lams.web.util.AttributeNames;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.lamsfoundation.lams.tool.exception.DataMissingException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerApplicationException;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerConstants;
import org.lamsfoundation.lams.tool.behaviourComposer.service.IBehaviourComposerService;
import org.lamsfoundation.lams.tool.behaviourComposer.service.BehaviourComposerServiceProxy;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerSession;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerUser;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.tool.behaviourComposer.util.BehaviourComposerWebUtil;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.ToolSessionManager;


/**
 * Creation Date: 29-06-05
 *  
 * This class has been created so that when a learner finishes an activity,
 * leaveToolSession() will be called to inform the progress engine
 * that the user has completed this activity.
 * 
 * A note: at the time of writing (11-08-05) a null pointer exception
 * occurs when making a call to leaveToolSession(). Will have to wait until
 * the learner side of things is tested first.
 * 
 * ----------------XDoclet Tags--------------------
 * 
 * @struts:action path="/learner" name="BehaviourComposerLearnerForm" scope="request" type="org.lamsfoundation.lams.tool.behaviourComposer.web.BehaviourComposerLearnerAction"
 *                input=".learnerContent" validate="false" parameter="method"
 * @struts:action-forward name="displayLearnerContent" path=".learnerContent"
 * ----------------XDoclet Tags--------------------
 */
public class BehaviourComposerLearnerAction extends LamsLookupDispatchAction {

    static Logger logger = Logger.getLogger(BehaviourComposerLearnerAction.class.getName());
    
    protected Map getKeyMethodMap()
	{
		Map map = new HashMap();
		map.put(BehaviourComposerConstants.BUTTON_FINISH, "finish");
		return map;
	}
    
    /** Get the user id from the shared session */
	public Long getUserID(HttpServletRequest request) {
		// set up the user details
		HttpSession ss = SessionManager.getSession();
		UserDTO user = (UserDTO) ss.getAttribute(AttributeNames.USER);
		if ( user == null )
		{
		    MessageResources resources = getResources(request);
		    String error = resources.getMessage(BehaviourComposerConstants.ERR_MISSING_PARAM, "User");
		    logger.error(error);
			throw new BehaviourComposerApplicationException(error);
		}
        return new Long(user.getUserID().longValue());
	}

    /**
     * Indicates that the user has finished viewing the behaviourComposer.
     * The session is set to complete and leaveToolSession is called.
     * @param mapping
     * @param form
     * @param request
     * @param response
     * @return
     */
    public ActionForward finish(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws BehaviourComposerApplicationException, ToolException, DataMissingException, ServletException, IOException {
		
	  BehaviourComposerLearnerForm learnerForm = (BehaviourComposerLearnerForm)form;
	  Long userID = getUserID(request);
	  
	  Long toolSessionID = BehaviourComposerWebUtil.convertToLong(learnerForm.getToolSessionID());
	  if (toolSessionID == null)
	  {
	      String error = "Unable to continue. The parameters tool session id is missing";
	      logger.error(error);
	      throw new BehaviourComposerApplicationException(error);
	  }
	  
	  IBehaviourComposerService behaviourComposerService = BehaviourComposerServiceProxy.getBehaviourComposerService(getServlet().getServletContext());
	  ToolSessionManager sessionMgrService = BehaviourComposerServiceProxy.getBehaviourComposerSessionManager(getServlet().getServletContext());
		  
      ToolAccessMode mode = WebUtil.getToolAccessMode(learnerForm.getMode());
      if (mode == ToolAccessMode.LEARNER || mode == ToolAccessMode.AUTHOR)
	  {
		  BehaviourComposerSession behaviourComposerSession = behaviourComposerService.retrieveBehaviourComposerSession(toolSessionID);
		  BehaviourComposerUser behaviourComposerUser = behaviourComposerService.retrieveBehaviourComposerUserBySession(userID,toolSessionID);
		  
		  behaviourComposerUser.setUserStatus(BehaviourComposerUser.COMPLETED);
		  behaviourComposerService.updateBehaviourComposerSession(behaviourComposerSession);
		  behaviourComposerService.updateBehaviourComposerUser(behaviourComposerUser);
		  
		  String nextActivityUrl;
			try
			{
				nextActivityUrl = sessionMgrService.leaveToolSession(toolSessionID, getUserID(request));
			}
			catch (DataMissingException e)
			{
				log.error(e);
				throw new ServletException(e);
			}
			catch (ToolException e)
			{
				log.error(e);
				throw new ServletException(e);
			}
	        
			response.sendRedirect(nextActivityUrl);
			
	        return null;
		  
		  
	  }
	  request.setAttribute(BehaviourComposerConstants.READ_ONLY_MODE, "true");
	  
	  return mapping.findForward(BehaviourComposerConstants.DISPLAY_LEARNER_CONTENT);
	  
	}
}
