/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: TestBehaviourComposerAttachmentDAO.java,v 1.5 2006/04/06 07:05:07 fmalikoff Exp $$ */
package org.lamsfoundation.lams.tool.behaviourComposer.dao.hibernate;

import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerDataAccessTestCase;
import org.lamsfoundation.lams.tool.behaviourComposer.dao.hibernate.BehaviourComposerAttachmentDAO;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerAttachment;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerContent;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerApplicationException;
import java.util.List;

/**
 * @author mtruong
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class TestBehaviourComposerAttachmentDAO extends BehaviourComposerDataAccessTestCase {

  /*  private BehaviourComposerAttachmentDAO attachmentDao;
    private BehaviourComposerContentDAO contentDao; 
    private BehaviourComposerAttachment behaviourComposerAttachment = null;
    private BehaviourComposerContent behaviourComposerContent = null; */
  
   
    public TestBehaviourComposerAttachmentDAO(String name)
    {
        super(name);
    }
    

    /**
     * @see BehaviourComposerDataAccessTestCase#setUp()
     */
	 protected void setUp() throws Exception {
	     super.setUp();
	     
	     initAllData();
	     initBehaviourComposerAttachmentData();
	 }
	 
	 /**
	  * @see BehaviourComposerDataAccessTestCase#tearDown()
	  */
	 protected void tearDown() throws Exception {
	    
	     cleanBehaviourComposerContentData(TEST_NB_ID);
	 }
	 
	 
	
	 public void testRetrieveAttachment()
	 {
	    
	    //test retrieveAttachmentByUuid
	    behaviourComposerAttachment = attachmentDAO.retrieveAttachmentByUuid(TEST_UUID);
	    assertAttachmentData(behaviourComposerAttachment);
	     
	     /* test getAttachmentsFromContent which will return a list of attachment ids, which we can use in the next method call to
	     retrieveAttachment which takes in the attachmentId as the parameter. */
	     List attachmentIds = attachmentDAO.getAttachmentIdsFromContent(behaviourComposerDAO.findBehaviourComposerContentById(TEST_NB_ID));
	     
	     //test retrieveAttachment (by attachmentId, which was retrieved from the previous method)
	     behaviourComposerAttachment = attachmentDAO.retrieveAttachment((Long)attachmentIds.get(0));
	     assertAttachmentData(behaviourComposerAttachment);
	     
	     //test retrieveAttachment (by filename as the parameter
	     behaviourComposerAttachment = attachmentDAO.retrieveAttachmentByFilename(TEST_FILENAME);
	     assertAttachmentData(behaviourComposerAttachment);
	 }
	 

	 
	 public void testSaveAttachment()
	 {
	     String newFilename = "new filename";
	     behaviourComposerAttachment = attachmentDAO.retrieveAttachmentByUuid(TEST_UUID);
	     behaviourComposerAttachment.setFilename(newFilename);
	     
	     attachmentDAO.saveAttachment(behaviourComposerAttachment);
	     
	     behaviourComposerAttachment = attachmentDAO.retrieveAttachmentByUuid(TEST_UUID);
	     assertEquals("Validating the new filename", behaviourComposerAttachment.getFilename(), newFilename);
	 }
	
	 public void testRemoveAttachment()
	 {
	     behaviourComposerAttachment = attachmentDAO.retrieveAttachmentByUuid(TEST_UUID);
	     //remove any associations
	     behaviourComposerContent = behaviourComposerDAO.findBehaviourComposerContentById(TEST_NB_ID);
	     behaviourComposerContent.getBehaviourComposerAttachments().remove(behaviourComposerAttachment);
	     
	     attachmentDAO.removeAttachment(behaviourComposerAttachment);
	     
	     behaviourComposerAttachment = attachmentDAO.retrieveAttachmentByUuid(TEST_UUID);
	     assertNull(behaviourComposerAttachment);
	     
	 } 
	 
	 public void testRemoveAttachmentByUuid()
	 {
	     behaviourComposerAttachment = attachmentDAO.retrieveAttachmentByUuid(TEST_UUID);
	     assertNotNull(behaviourComposerAttachment);
	     
	     //	   remove any associations
	     behaviourComposerContent = behaviourComposerDAO.findBehaviourComposerContentById(TEST_NB_ID);
	     behaviourComposerContent.getBehaviourComposerAttachments().remove(behaviourComposerAttachment);	
	     
	     attachmentDAO.removeAttachment(TEST_UUID);
	     
	     behaviourComposerAttachment = attachmentDAO.retrieveAttachmentByUuid(TEST_UUID);
	     assertNull(behaviourComposerAttachment);
	     
	 } 
	 
	
	
	 
	 
}
