/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: IBehaviourComposerContentDAO.java,v 1.5 2006/04/06 07:05:07 fmalikoff Exp $$ */
package org.lamsfoundation.lams.tool.behaviourComposer.dao;

import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerContent;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerSession;

/**
 * <p>Interface for the BehaviourComposerContent DAO, defines methods needed to access/modify
 * behaviourComposer content</p>
 * @author mtruong
 */
public interface IBehaviourComposerContentDAO {
    
    
    /**
	 * <p>Return the persistent instance of a BehaviourComposerContent  
	 * with the given identifier <code>uid</code>, returns null if not found. </p>
	 * 
	 * @param uid an identifier for the BehaviourComposerContent instance.
	 * @return the persistent instance of a BehaviourComposerContent or null if not found
	 */
	public BehaviourComposerContent getBehaviourComposerContentByUID(Long uid);
	
	/**
	 * <p> Return the persistent instance of a BehaviourComposerContent
	 * with the given tool content id <code>behaviourComposerContentId</code>,
	 * returns null if not found.</p>
	 * 
	 * @param behaviourComposerContentId The tool content id
	 * @return the persistent instance of a BehaviourComposerContent or null if not found.
	 */
	public BehaviourComposerContent findBehaviourComposerContentById(Long behaviourComposerContentId);
	
	/**
     * <p> Returns the persistent instance of BehaviourComposerContent
     * with the given tool session id <code>behaviourComposerSessionId</code>, returns null if not found.
     * 
     * @param behaviourComposerSessionId The tool session id
     * @return a persistent instance of BehaviourComposerContent or null if not found.
     */
	public BehaviourComposerContent getBehaviourComposerContentBySession(Long behaviourComposerSessionId);
    
	/**
	 * <p>Persist the given persistent instance of BehaviourComposerContent.</p>
	 * 
	 * @param behaviourComposerContent The instance of BehaviourComposerContent to persist.
	 */
    public void saveBehaviourComposerContent(BehaviourComposerContent behaviourComposerContent);
    
    /**
     * <p>Update the given persistent instance of BehaviourComposerContent.</p>
     * 
     * @param behaviourComposerContent The instance of BehaviourComposerContent to persist.
     */
    public void updateBehaviourComposerContent(BehaviourComposerContent behaviourComposerContent);

    /**
     * <p>Delete the given instance of BehaviourComposerContent</p>
     * 
     * @param behaviourComposerContent The instance of BehaviourComposerContent to delete. 
     */
    public void removeBehaviourComposer(BehaviourComposerContent behaviourComposerContent);
    
    /**
     * <p>Delete the given instance of BehaviourComposerContent with the
     * given tool content id <code>behaviourComposerContentId</code>
     * 
     * @param behaviourComposerContentId The tool content Id. 
     */
    public void removeBehaviourComposer(Long behaviourComposerContentId);
   
    
    /**
     * <p>Deletes all instances of BehaviourComposerSession that are associated
     * with the given instance of BehaviourComposerContent</p>
     * 
     * @param behaviourComposerContent The instance of BehaviourComposerContent in which corresponding instances of BehaviourComposerSession should be deleted.
     */
    public void removeBehaviourComposerSessions(BehaviourComposerContent behaviourComposerContent);
    
    /**
     * <p>Creates a persistent instance of BehaviourComposerSession which is associated
     * with the BehaviourComposerContent with tool content id <code>behaviourComposerContentId</code> 
     * </p>
     * 
     * @param behaviourComposerContentId The tool content id
     * @param behaviourComposerSession The instance of BehaviourComposerSession to add
     */
    public void addBehaviourComposerSession(Long behaviourComposerContentId, BehaviourComposerSession behaviourComposerSession);
    
  }
