/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: BehaviourComposerContentDAO.java,v 1.7 2006/04/06 07:05:07 fmalikoff Exp $$ */
package org.lamsfoundation.lams.tool.behaviourComposer.dao.hibernate;

import java.util.List;
import java.lang.Long;

import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerContent;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerSession;
import org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerContentDAO;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

/**
 * @author mtruong
 * <p>Hibernate implementation for database access to BehaviourComposer content for the behaviourComposer tool.</p>
 */

public class BehaviourComposerContentDAO extends HibernateDaoSupport implements IBehaviourComposerContentDAO {
	
	private static final String FIND_NB_CONTENT = "from " + BehaviourComposerContent.class.getName() + " as behaviourComposer where behaviourComposer.behaviourComposerContentId=?";
	
	
	private static final String LOAD_NB_BY_SESSION = "select behaviourComposer from BehaviourComposerContent behaviourComposer left join fetch "
        + "behaviourComposer.behaviourComposerSessions session where session.behaviourComposerSessionId=:sessionId";

	
	/** @see org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerContentDAO#getBehaviourComposerContentByUID(java.lang.Long) */
	public BehaviourComposerContent getBehaviourComposerContentByUID(Long uid)
	{
		 return (BehaviourComposerContent) this.getHibernateTemplate()
         .get(BehaviourComposerContent.class, uid);
	}
	
	/** @see org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerContentDAO#findBehaviourComposerContentById(java.lang.Long) */
	public BehaviourComposerContent findBehaviourComposerContentById(Long behaviourComposerContentId)
	{
	    String query = "from BehaviourComposerContent as behaviourComposer where behaviourComposer.behaviourComposerContentId = ?";
		List content = getHibernateTemplate().find(query,behaviourComposerContentId);
			
		if(content!=null && content.size() == 0)
		{			
			return null;
		}
		else
		{
			return (BehaviourComposerContent)content.get(0);
		}
	
	}
    	
	/** @see org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerContentDAO#getBehaviourComposerContentBySession(java.lang.Long) */
	public BehaviourComposerContent getBehaviourComposerContentBySession(final Long behaviourComposerSessionId)
	{
		 return (BehaviourComposerContent) getHibernateTemplate().execute(new HibernateCallback()
                {

                    public Object doInHibernate(Session session) throws HibernateException
                    {
                        return session.createQuery(LOAD_NB_BY_SESSION)
                                      .setLong("sessionId",
                                      		behaviourComposerSessionId.longValue())
                                      .uniqueResult();
                    }
                });
	}
	
	
	/** @see org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerContentDAO#saveBehaviourComposerContent(org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerContent) */
	public void saveBehaviourComposerContent(BehaviourComposerContent behaviourComposerContent)
    {
    	this.getHibernateTemplate().save(behaviourComposerContent);
    }
    
	/** @see org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerContentDAO#updateBehaviourComposerContent(org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerContent) */
	public void updateBehaviourComposerContent(BehaviourComposerContent behaviourComposerContent)
    {
    	this.getHibernateTemplate().update(behaviourComposerContent);
    }

   
	/** @see org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerContentDAO#removeBehaviourComposer(java.lang.Long)*/
	public void removeBehaviourComposer(Long behaviourComposerContentId)
    {       
       	if ( behaviourComposerContentId != null) {
			//String query = "from org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerContent as behaviourComposer where behaviourComposer.behaviourComposerContentId=?";
			List list = getSession().createQuery(FIND_NB_CONTENT)
				.setLong(0,behaviourComposerContentId.longValue())
				.list();
			
			if(list != null && list.size() > 0){
				BehaviourComposerContent behaviourComposer = (BehaviourComposerContent) list.get(0);
				this.getSession().setFlushMode(FlushMode.AUTO);
				this.getHibernateTemplate().delete(behaviourComposer);
				this.getHibernateTemplate().flush();
			}
		}
    }
    
	/** @see org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerContentDAO#removeBehaviourComposer(org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerContent)*/
    public void removeBehaviourComposer(BehaviourComposerContent behaviourComposerContent)
    {
    	removeBehaviourComposer(behaviourComposerContent.getBehaviourComposerContentId());
    }
   
    /** @see org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerContentDAO#removeBehaviourComposerSessions(org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerContent)*/
    public void removeBehaviourComposerSessions(BehaviourComposerContent behaviourComposerContent)
    {
    	this.getHibernateTemplate().deleteAll(behaviourComposerContent.getBehaviourComposerSessions());
    }
    
    /** @see org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerContentDAO#addBehaviourComposerSession(java.lang.Long, org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerSession) */
    public void addBehaviourComposerSession(Long behaviourComposerContentId, BehaviourComposerSession behaviourComposerSession)
    {
        BehaviourComposerContent content = findBehaviourComposerContentById(behaviourComposerContentId);
        behaviourComposerSession.setBehaviourComposerContent(content);
        content.getBehaviourComposerSessions().add(behaviourComposerSession);
        this.getHibernateTemplate().saveOrUpdate(behaviourComposerSession);
        this.getHibernateTemplate().saveOrUpdate(content);        
    }
  
}
