/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: BehaviourComposerServiceProxy.java,v 1.7 2006/04/06 07:05:06 fmalikoff Exp $$ */
package org.lamsfoundation.lams.tool.behaviourComposer.service;

import javax.servlet.ServletContext;

import org.lamsfoundation.lams.tool.ToolContentManager;
import org.lamsfoundation.lams.tool.ToolSessionManager;
import org.lamsfoundation.lams.tool.behaviourComposer.util.BehaviourComposerToolContentHandler;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;


/**
 * <p>This class act as the proxy between web layer and service layer. It is
 * designed to decouple the presentation logic and business logic completely.
 * In this way, the presentation tier will no longer be aware of the changes in
 * service layer. Therefore we can feel free to switch the business logic
 * implementation.</p>
 *
 * @author mtruong
 */

public class BehaviourComposerServiceProxy {

	public static final IBehaviourComposerService getBehaviourComposerService(ServletContext servletContext)
    {
        return (IBehaviourComposerService)getBehaviourComposerDomainService(servletContext);
    }
	
	private static Object getBehaviourComposerDomainService(ServletContext servletContext)
	{
		WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext(servletContext);
	    return wac.getBean("behaviourComposerService");
	}
	
	 /*
     * Return the behaviourComposer version of tool session manager implementation. 
     * It will delegate to the Spring helper method to retrieve the proper 
     * bean from Spring bean factory.
     * @param servletContext the servletContext for current application
     * @return behaviourComposer service object.*/
    public static final ToolSessionManager getBehaviourComposerSessionManager(ServletContext servletContext)
    {
        return (ToolSessionManager)getBehaviourComposerDomainService(servletContext);
    }
     
    
    /*
     * Return the behaviourComposer version of tool content manager implementation. 
     * It will delegate to the Spring helper method to retrieve the proper 
     * bean from Spring bean factory.
     * @param servletContext the servletContext for current application
     * @return behaviourComposer service object. */
    public static final ToolContentManager getBehaviourComposerContentManager(ServletContext servletContext)
    {
        return (ToolContentManager)getBehaviourComposerDomainService(servletContext);
    }

}
