/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: TestBehaviourComposerSessionDAO.java,v 1.8 2006/07/14 04:56:36 fmalikoff Exp $$ */
package org.lamsfoundation.lams.tool.behaviourComposer.dao.hibernate;

import java.util.Date;
import java.util.List;
import java.util.Iterator;


import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerDataAccessTestCase;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerContent;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerSession;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerUser;



/**
 * @author mtruong
 *
 * JUnit Test Cases to test the BehaviourComposerSessionDAO class
 */
public class TestBehaviourComposerSessionDAO extends BehaviourComposerDataAccessTestCase {
	
	
	private BehaviourComposerSession behaviourComposerSession = null;
	private BehaviourComposerContent behaviourComposerContent = null;
	
	
	//private boolean cleanSessionContentData = false;
	private boolean cleanContentData = true;
	
	public TestBehaviourComposerSessionDAO(String name)
	{
		super(name);
	}
	
	 /**
     * @see BehaviourComposerDataAccessTestCase#setUp()
     */
	 protected void setUp() throws Exception {
	 	super.setUp();
       initAllData();
    }
	 
	/**
	 * @see BehaviourComposerDataAccessTestCase#tearDown()
	 */
    protected void tearDown() throws Exception {
        
        if(cleanContentData)
        {
        	super.cleanBehaviourComposerContentData(TEST_NB_ID);
        }
       
    }

  /* public void testgetBehaviourComposerSessionByUID()
    {
       behaviourComposerSession = behaviourComposerSessionDAO.getBehaviourComposerSessionByUID(new Long(1)); //default test data which is always in db
        
       assertEquals(behaviourComposerSession.getBehaviourComposerSessionId(), DEFAULT_SESSION_ID);
       assertEquals(behaviourComposerSession.getSessionStatus(), DEFAULT_SESSION_STATUS);
        
    } */
    
    public void testfindBehaviourComposerSessionById()
    {
        behaviourComposerSession = behaviourComposerSessionDAO.findBehaviourComposerSessionById(TEST_SESSION_ID);
        assertEqualsForSessionContent(behaviourComposerSession);
        
        Long nonExistentSessionId = new Long(7657);
        assertSessionObjectIsNull(nonExistentSessionId); 
    }
    
    public void testsaveBehaviourComposerSession()
    {
        BehaviourComposerContent behaviourComposerContentToReference = behaviourComposerDAO.findBehaviourComposerContentById(TEST_NB_ID);
        
        Long newSessionId = new Long(2222);
        Date newDateCreated = new Date(System.currentTimeMillis());
        BehaviourComposerSession newSessionObject = new BehaviourComposerSession(newSessionId,
        															"Session "+newSessionId,
                													behaviourComposerContentToReference,
                													newDateCreated,
                													BehaviourComposerSession.NOT_ATTEMPTED);
        
        behaviourComposerContentToReference.getBehaviourComposerSessions().add(newSessionObject);
        behaviourComposerDAO.updateBehaviourComposerContent(behaviourComposerContentToReference);
        
        behaviourComposerSessionDAO.saveBehaviourComposerSession(newSessionObject);
        
        //Retrieve the newly added session object and test its values
        
        behaviourComposerSession = behaviourComposerSessionDAO.findBehaviourComposerSessionById(newSessionId);
        
        assertEquals(behaviourComposerSession.getBehaviourComposerSessionId(), newSessionId);
        assertEquals(behaviourComposerSession.getSessionStartDate(), newDateCreated);
        
    } 
    
    public void testupdateBehaviourComposerSession()
    {
        behaviourComposerSession = behaviourComposerSessionDAO.findBehaviourComposerSessionById(TEST_SESSION_ID);
        
        behaviourComposerSession.setSessionStatus(BehaviourComposerSession.COMPLETED);
        
        behaviourComposerSessionDAO.updateBehaviourComposerSession(behaviourComposerSession);
        
        BehaviourComposerSession updatedSession = behaviourComposerSessionDAO.findBehaviourComposerSessionById(TEST_SESSION_ID);
        
        assertEquals(updatedSession.getSessionStatus(), BehaviourComposerSession.COMPLETED);
    } 
    
  /*  public void testremoveBehaviourComposerSessionByUID()
    {
        BehaviourComposerSession existingSession = behaviourComposerSessionDAO.findBehaviourComposerSessionById(TEST_SESSION_ID);
        Long uid = existingSession.getUid();
        
        BehaviourComposerContent referencedContent = existingSession.getBehaviourComposerContent();
        
        behaviourComposerSessionDAO.removeBehaviourComposerSessionByUID(uid);
        referencedContent.getBehaviourComposerSessions().remove(existingSession);
        
        behaviourComposerDAO.updateBehaviourComposerContent(referencedContent);
        
        assertSessionObjectIsNull(TEST_SESSION_ID);
    } */
    
    
    public void testremoveBehaviourComposerSessionById()
    {
        behaviourComposerSession = behaviourComposerSessionDAO.findBehaviourComposerSessionById(TEST_SESSION_ID);
        behaviourComposerContent = behaviourComposerSession.getBehaviourComposerContent();
        behaviourComposerContent.getBehaviourComposerSessions().remove(behaviourComposerSession);
        
        behaviourComposerSessionDAO.removeBehaviourComposerSession(TEST_SESSION_ID);
        
        behaviourComposerDAO.updateBehaviourComposerContent(behaviourComposerContent);
        
        assertSessionObjectIsNull(TEST_SESSION_ID);
        
    }
    
    public void testremoveBehaviourComposerSession()
    {
        behaviourComposerSession = behaviourComposerSessionDAO.findBehaviourComposerSessionById(TEST_SESSION_ID);
        behaviourComposerContent = behaviourComposerSession.getBehaviourComposerContent();
        behaviourComposerContent.getBehaviourComposerSessions().remove(behaviourComposerSession);
        
        behaviourComposerSessionDAO.removeBehaviourComposerSession(behaviourComposerSession);
        
        behaviourComposerDAO.updateBehaviourComposerContent(behaviourComposerContent);
        
        assertSessionObjectIsNull(TEST_SESSION_ID);
    } 
    
    public void testGetBehaviourComposerSessionByUser()
    {
        behaviourComposerSession = behaviourComposerSessionDAO.getBehaviourComposerSessionByUser(TEST_USER_ID);
        assertEqualsForSessionContent(behaviourComposerSession);
    }
    
    public void testRemoveBehaviourComposerUsers()
    {
        behaviourComposerSession = behaviourComposerSessionDAO.findBehaviourComposerSessionById(TEST_SESSION_ID);
        
        behaviourComposerSessionDAO.removeBehaviourComposerUsers(behaviourComposerSession);
        behaviourComposerSession.getBehaviourComposerUsers().clear();
        behaviourComposerSessionDAO.updateBehaviourComposerSession(behaviourComposerSession);
        
        BehaviourComposerSession ns = behaviourComposerSessionDAO.findBehaviourComposerSessionById(TEST_SESSION_ID);
        
        assertNotNull(ns);
        assertUserObjectIsNull(TEST_USER_ID);
    }
    
    public void testAddUsers()
    {
        Long newUserId = new Long(123);
        BehaviourComposerUser newUser = new BehaviourComposerUser(newUserId);
        
        behaviourComposerSessionDAO.addBehaviourComposerUsers(TEST_SESSION_ID, newUser);
        
        BehaviourComposerUser retrievedUser = behaviourComposerUserDAO.getBehaviourComposerUserByID(newUserId);
        
        assertEquals(retrievedUser.getBehaviourComposerSession().getBehaviourComposerSessionId(), TEST_SESSION_ID);
    }
    
    public void testGetSessionsFromContent()
    {
        behaviourComposerSession = behaviourComposerSessionDAO.findBehaviourComposerSessionById(TEST_SESSION_ID);
        BehaviourComposerContent content = behaviourComposerSession.getBehaviourComposerContent();
        List list = behaviourComposerSessionDAO.getSessionsFromContent(content);
        assertEquals(list.size(), 1);
        
        Iterator i = list.iterator();
        
        while (i.hasNext())
        {
            Long sessionID = (Long)i.next();
            assertEquals(sessionID, TEST_SESSION_ID);
        }
        
    }
   
}
