/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: TestBehaviourComposerServicePOJO.java,v 1.16 2006/07/14 04:56:36 fmalikoff Exp $$ */
package org.lamsfoundation.lams.tool.behaviourComposer.service;

import java.util.Date;
import java.util.List;
import java.util.Iterator;


import org.lamsfoundation.lams.contentrepository.RepositoryCheckedException;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerApplicationException;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerDataAccessTestCase;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerContent;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerConstants;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerSession;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerUser;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerAttachment;
import org.lamsfoundation.lams.tool.behaviourComposer.service.IBehaviourComposerService;


/**
 * @author mtruong
 *
 */
public class TestBehaviourComposerServicePOJO extends BehaviourComposerDataAccessTestCase 
{
	
	private IBehaviourComposerService behaviourComposerService = null;
/*	private BehaviourComposerContent behaviourComposerContent;
	private BehaviourComposerSession behaviourComposerSession;
	private BehaviourComposerUser behaviourComposerUser; 
	private BehaviourComposerAttachment behaviourComposerAttachment;*/
	
	private boolean cleanContentData = true;

	
	public TestBehaviourComposerServicePOJO(String name)
	{
		super(name);
	}

	protected void setUp() throws Exception
	{
		super.setUp();
		
		behaviourComposerService = (IBehaviourComposerService)this.context.getBean("behaviourComposerService");
		initAllData();
		
	}
	
	protected void tearDown() throws Exception
	{
		//delete data
		if(cleanContentData)
        {
        	cleanBehaviourComposerContentData(TEST_NB_ID);
        }
       
	}
	
	/* ==============================================================================
	 * Methods for access to BehaviourComposerContent objects
	 * ==============================================================================
	 */
		
	public void testRetrieveBehaviourComposer()
	{
	    behaviourComposerContent = behaviourComposerService.retrieveBehaviourComposer(TEST_NB_ID);
		
	    assertContentEqualsTestData(behaviourComposerContent);
	
	}
	
	public void testUpdateBehaviourComposer()
	{
	    String newContent = "New updated content";
	    behaviourComposerContent = behaviourComposerService.retrieveBehaviourComposer(TEST_NB_ID);
	    behaviourComposerContent.setContent(newContent);
		
		//save the new changes
		behaviourComposerService.saveBehaviourComposer(behaviourComposerContent);
		
		//check whether the changes has been saved
		BehaviourComposerContent newBehaviourComposer = behaviourComposerService.retrieveBehaviourComposer(TEST_NB_ID);
		
		assertEquals(newBehaviourComposer.getTitle(), TEST_TITLE);
    	assertEquals(newBehaviourComposer.getContent(), newContent);
    	assertEquals(newBehaviourComposer.getOnlineInstructions(), TEST_ONLINE_INSTRUCTIONS);
    	assertEquals(newBehaviourComposer.getOfflineInstructions(), TEST_OFFLINE_INSTRUCTIONS);
    	assertEquals(newBehaviourComposer.isDefineLater(), TEST_DEFINE_LATER);
    	assertEquals(newBehaviourComposer.isForceOffline(), TEST_FORCE_OFFLINE);
    	assertEquals(newBehaviourComposer.getCreatorUserId(), TEST_CREATOR_USER_ID);
    	assertEquals(newBehaviourComposer.getDateCreated(), TEST_DATE_CREATED); 
	}
	
	public void testSaveBehaviourComposer()
	{
	    Long testToolContentId = new Long(8000);
		String testTitle = "TestCase: saveBehaviourComposer()";
		String testContent = "This is to test the saveBehaviourComposer() function";
		String testOnlineInstructions = "online instructions";
		String testOfflineInstructions = "offline instructions";
		
		BehaviourComposerContent content = new BehaviourComposerContent(testToolContentId,
		        											testTitle,
		        											testContent,
		        											testOnlineInstructions,
		        											testOfflineInstructions,
		        											new Date(System.currentTimeMillis()));
		behaviourComposerService.saveBehaviourComposer(content);
		
		BehaviourComposerContent retrievedObject = behaviourComposerService.retrieveBehaviourComposer(testToolContentId);
		assertEquals(retrievedObject.getTitle(), testTitle);
		assertEquals(retrievedObject.getContent(), testContent);
		assertEquals(retrievedObject.getOnlineInstructions(), testOnlineInstructions);
		assertEquals(retrievedObject.getOfflineInstructions(), testOfflineInstructions);
		
		//remove test data
		
		behaviourComposerService.removeBehaviourComposer(testToolContentId);
	}
	
	public void testremoveBehaviourComposerSessions()
	{
	    behaviourComposerContent = behaviourComposerService.retrieveBehaviourComposer(TEST_NB_ID);
	    
	    behaviourComposerService.removeBehaviourComposerSessionsFromContent(behaviourComposerContent);
	    
	    behaviourComposerSession = behaviourComposerService.retrieveBehaviourComposerSession(TEST_SESSION_ID);
	    assertNull(behaviourComposerSession);
	    
	} 
	
	public void testRemoveBehaviourComposerByID()
	{
	    cleanContentData = false;
	    behaviourComposerService.removeBehaviourComposer(TEST_NB_ID);
	    
	    BehaviourComposerContent behaviourComposer = behaviourComposerService.retrieveBehaviourComposer(TEST_NB_ID);
	    assertNull(behaviourComposer);
	}
	
	public void testRemoveBehaviourComposer()
	{
	    cleanContentData = false;
	    behaviourComposerService.removeBehaviourComposer(behaviourComposerService.retrieveBehaviourComposer(TEST_NB_ID));
	    
	    BehaviourComposerContent behaviourComposer = behaviourComposerService.retrieveBehaviourComposer(TEST_NB_ID);
	    assertNull(behaviourComposer);
	}
	
	/* ==============================================================================
	 * Methods for access to BehaviourComposerSession objects
	 * ==============================================================================
	 */
	
	public void testRetrieveBehaviourComposerSession()
	{
	    behaviourComposerSession = behaviourComposerService.retrieveBehaviourComposerSession(TEST_SESSION_ID);
	    assertEqualsForSessionContent(behaviourComposerSession);
	}
	
	
	public void testSaveBehaviourComposerSession()
	{
	    Long testSessionId = new Long(9000);
	    Long testContentId = new Long(9500);
	    Date created = new Date(System.currentTimeMillis());
	    
	    BehaviourComposerContent behaviourComposerContent = new BehaviourComposerContent();
	    behaviourComposerContent.setBehaviourComposerContentId(testContentId);
	    behaviourComposerService.saveBehaviourComposer(behaviourComposerContent);
	    
	   BehaviourComposerSession behaviourComposerSession = new BehaviourComposerSession(testSessionId,
			   													"Session "+testSessionId,
	            												behaviourComposerContent,
	            												created,
	            												BehaviourComposerSession.NOT_ATTEMPTED); 
	    behaviourComposerService.addSession(testContentId, behaviourComposerSession);
	 
	    
	   	BehaviourComposerSession retrievedSession = behaviourComposerService.retrieveBehaviourComposerSession(testSessionId);
	    
	    assertEquals(retrievedSession.getBehaviourComposerContent().getBehaviourComposerContentId(), testContentId);
	    assertEquals(retrievedSession.getSessionStartDate(), created);
	    assertEquals(retrievedSession.getSessionStatus(), BehaviourComposerSession.NOT_ATTEMPTED);
	    
	    //remove test data
	    behaviourComposerService.removeBehaviourComposer(testContentId);
	}
	
	public void testUpdateBehaviourComposerSession()
	{
	    behaviourComposerSession = behaviourComposerService.retrieveBehaviourComposerSession(TEST_SESSION_ID);
	   	Date date = new Date(System.currentTimeMillis());
	   
	   	behaviourComposerSession.setSessionStatus(BehaviourComposerSession.COMPLETED);
	   	behaviourComposerSession.setSessionEndDate(date);
	   	
	   	behaviourComposerService.updateBehaviourComposerSession(behaviourComposerSession);
	   	
	   	BehaviourComposerSession retrievedSession = behaviourComposerService.retrieveBehaviourComposerSession(TEST_SESSION_ID);
	   	
	   	assertEquals(retrievedSession.getSessionStatus(), BehaviourComposerSession.COMPLETED);
	   	assertEquals(retrievedSession.getSessionEndDate(), date);
	}
	
	public void testRemoveSessionByID()
	{
	 
	    behaviourComposerService.removeSession(TEST_SESSION_ID);
	 	    
	    assertSessionObjectIsNull(TEST_SESSION_ID);
	}
	
	public void testRemoveSession()
	{
	    behaviourComposerSession = behaviourComposerService.retrieveBehaviourComposerSession(TEST_SESSION_ID);
	    
	    behaviourComposerService.removeSession(behaviourComposerSession);
		    
	    assertSessionObjectIsNull(TEST_SESSION_ID);
	    
	}
	
	public void testRemoveBehaviourComposerUsersFromSession()
	{
	    behaviourComposerSession = behaviourComposerService.retrieveBehaviourComposerSession(TEST_SESSION_ID);	    
	    
	    behaviourComposerService.removeBehaviourComposerUsersFromSession(behaviourComposerSession);
	    
	    behaviourComposerUser = behaviourComposerService.retrieveBehaviourComposerUser(TEST_USER_ID);
	    assertNull(behaviourComposerUser);
	    
	}
	
	/* ==============================================================================
	 * Methods for access to BehaviourComposerUser objects
	 * ==============================================================================
	 */
	public void testRetrieveBehaviourComposerUser()
	{
	    behaviourComposerUser = behaviourComposerService.retrieveBehaviourComposerUser(TEST_USER_ID);
	    
	    assertEqualsForBehaviourComposerUser(behaviourComposerUser);
	}

	
	public void testSaveBehaviourComposerUser()
	{
	    Long newUserId = new Long(8756);
	    behaviourComposerSession = behaviourComposerService.retrieveBehaviourComposerSession(TEST_SESSION_ID);
	    
	    BehaviourComposerUser user = new BehaviourComposerUser(newUserId, behaviourComposerSession);
	    
	  
	    behaviourComposerService.saveBehaviourComposerUser(user);
	    
	    BehaviourComposerUser userInDb = behaviourComposerService.retrieveBehaviourComposerUser(newUserId);
	    assertEquals(userInDb.getUserId(), newUserId);
	    assertEquals(userInDb.getBehaviourComposerSession().getBehaviourComposerSessionId(), TEST_SESSION_ID);
	}
	
	public void testUpdateBehaviourComposerUser()
	{
	    behaviourComposerUser = behaviourComposerService.retrieveBehaviourComposerUser(TEST_USER_ID);
	    behaviourComposerUser.setUserStatus(BehaviourComposerUser.COMPLETED);
	    
	    behaviourComposerService.updateBehaviourComposerUser(behaviourComposerUser);
	    
	    BehaviourComposerUser updatedUser = behaviourComposerService.retrieveBehaviourComposerUser(TEST_USER_ID);
	    
	    assertEquals(updatedUser.getUserStatus(), BehaviourComposerUser.COMPLETED);
	}
	
	public void testRemoveUserById()
	{
	  
	    behaviourComposerService.removeUser(TEST_USER_ID);
	    
	    assertUserObjectIsNull(TEST_USER_ID);
	  
	}
	
	public void testRemoveUser()
	{
	    behaviourComposerUser = behaviourComposerService.retrieveBehaviourComposerUser(TEST_USER_ID);
	
	    behaviourComposerService.removeUser(behaviourComposerUser);
	    
	    assertUserObjectIsNull(TEST_USER_ID);
	  
	}
	
	public void testAddSession()
	{
	    Long toolSessionId = new Long(99);
	    BehaviourComposerSession newSession = new BehaviourComposerSession(toolSessionId);
        behaviourComposerService.addSession(TEST_NB_ID, newSession);
        
        BehaviourComposerSession session = behaviourComposerService.retrieveBehaviourComposerSession(toolSessionId);
        assertEquals(session.getBehaviourComposerContent().getBehaviourComposerContentId(), TEST_NB_ID);
       
	}
	
	public void testAddUser()
	{
	    Long userId = new Long(88);
	    BehaviourComposerUser newUser = new BehaviourComposerUser(userId);
        behaviourComposerService.addUser(TEST_SESSION_ID, newUser);
        
        BehaviourComposerUser user = behaviourComposerService.retrieveBehaviourComposerUser(userId);
        assertEquals(user.getBehaviourComposerSession().getBehaviourComposerSessionId(), TEST_SESSION_ID);
	}
	
	public void testGetSessionIdsFromContent()
	{
	    BehaviourComposerContent content = behaviourComposerService.retrieveBehaviourComposer(TEST_NB_ID);
	    List list = behaviourComposerService.getSessionIdsFromContent(content);
	    
	    assertEquals(list.size(), 1);
	    Iterator i = list.iterator();
        
        while (i.hasNext())
        {
            Long sessionID = (Long)i.next();
            assertEquals(sessionID, TEST_SESSION_ID);
        }
	}
	
	public void testGetNumberOfUsersInSession()
	{
	    BehaviourComposerSession session = behaviourComposerService.retrieveBehaviourComposerSession(TEST_SESSION_ID);
	    int numberOfUsers = behaviourComposerService.getNumberOfUsersInSession(session);
	    assertEquals(numberOfUsers, 1);
	    
	    //now add more users in the session
	    Long userId1 = new Long(34);
	    Long userId2 = new Long(35);
	    BehaviourComposerUser user1 = new BehaviourComposerUser(userId1, session);
	    BehaviourComposerUser user2 = new BehaviourComposerUser(userId2, session);
	    behaviourComposerService.saveBehaviourComposerUser(user1);
	    behaviourComposerService.saveBehaviourComposerUser(user2);
	    
	    //now retrieve and there should be 3 users for this session
	    behaviourComposerSession = behaviourComposerService.retrieveBehaviourComposerSession(TEST_SESSION_ID);
	    int newNumberOfUsers = behaviourComposerService.getNumberOfUsersInSession(behaviourComposerSession);
	    assertEquals(newNumberOfUsers, 3);
	    
	  //  int totalNumberOfLearners = behaviourComposerService.calculateTotalNumberOfUsers(TEST_NB_ID);
	    //assertEquals(totalNumberOfLearners, 3);
	}
	



	public void testCalculateTotalNumberOfUsers()
	{
	    /* add more sessions relating to the test tool content id and add more users in each session
	     * then calculate the total number of users for this tool activity
	     */
	    Long sessionId1, sessionId2, sessionId3;
	    Long userId1, userId2, userId3, userId4, userId5, userId6;
	    BehaviourComposerSession session1, session2, session3;
	    BehaviourComposerUser user1Sess1, user2Sess1, user3Sess1, user4Sess2, user5Sess2, user6Sess3;
	    behaviourComposerContent = behaviourComposerService.retrieveBehaviourComposer(TEST_NB_ID);
	    //create more sessions
	    sessionId1 = new Long(456); sessionId2 = new Long(457); sessionId3 = new Long(458);
	    userId1 = new Long(567); userId2 = new Long(568); userId3 = new Long(569);
	    userId4 = new Long(570); userId5 = new Long(571); userId6 = new Long(572);
	    
	    session1 = new BehaviourComposerSession(sessionId1, "Session "+sessionId1, behaviourComposerContent);
	    session2 = new BehaviourComposerSession(sessionId2, "Session "+sessionId1, behaviourComposerContent);
	    session3 = new BehaviourComposerSession(sessionId3, "Session "+sessionId1, behaviourComposerContent);
	    
	    behaviourComposerContent.getBehaviourComposerSessions().add(session1);
	    behaviourComposerContent.getBehaviourComposerSessions().add(session2);
	    behaviourComposerContent.getBehaviourComposerSessions().add(session3);
	    
	    behaviourComposerService.saveBehaviourComposer(behaviourComposerContent);
	    
	    user1Sess1 = new BehaviourComposerUser(userId1, session1);
	    user2Sess1 = new BehaviourComposerUser(userId2, session1);
	    user3Sess1 = new BehaviourComposerUser(userId3, session1);
	    user4Sess2 = new BehaviourComposerUser(userId4, session2);
	    user5Sess2 = new BehaviourComposerUser(userId5, session2);
	    user6Sess3 = new BehaviourComposerUser(userId6, session3);
	    
	    session1.getBehaviourComposerUsers().add(user1Sess1);
	    session1.getBehaviourComposerUsers().add(user2Sess1);  
	    session1.getBehaviourComposerUsers().add(user3Sess1);
	    
	    session2.getBehaviourComposerUsers().add(user4Sess2);
	    session2.getBehaviourComposerUsers().add(user5Sess2);
	    
	    session3.getBehaviourComposerUsers().add(user6Sess3);
	    
	    behaviourComposerService.saveBehaviourComposerSession(session1);
	    behaviourComposerService.saveBehaviourComposerSession(session2);
	    behaviourComposerService.saveBehaviourComposerSession(session3);
	    

	    //now test the function
	    int totalUsers = behaviourComposerService.calculateTotalNumberOfUsers(TEST_NB_ID);
	    assertEquals("testing the total number of users", totalUsers, 7);
	    
	    
	}







/* ==============================================================================
	 * Methods for access to BehaviourComposerAttachment objects
	 * ==============================================================================
	 */
	
	public void testRetrieveAttachment()
	{
	    initBehaviourComposerAttachmentData();
	    //test retrieveAttachmentByUuid
	    behaviourComposerAttachment = behaviourComposerService.retrieveAttachmentByUuid(TEST_UUID);
	    
	    assertAttachmentData(behaviourComposerAttachment);
	    /* test getAttachmentsFromContent which will return a list of behaviourComposerAttachment ids, which we can use in the next method call to
	     retrieveAttachment which takes in the attachmentId as the parameter. */
	    List idList = behaviourComposerService.getAttachmentIdsFromContent(behaviourComposerService.retrieveBehaviourComposer(TEST_NB_ID));
	    
	    //test retrieveAttachment (by attachmentId, which was retrieved from the previous method)
	    behaviourComposerAttachment = behaviourComposerService.retrieveAttachment((Long)idList.get(0));
	    assertAttachmentData(behaviourComposerAttachment);
	    
	    //test retrieveAttachmentByFilename;
	    behaviourComposerAttachment = behaviourComposerService.retrieveAttachmentByFilename(TEST_FILENAME);
	    assertAttachmentData(behaviourComposerAttachment);
	}
	
	 public void testRetrieveAttachmentWithNullParameters() throws BehaviourComposerApplicationException
	 {
	     //retrieve behaviourComposerAttachment by filename
	     try
	     {
	         behaviourComposerService.retrieveAttachmentByFilename(null);
	         fail("An exception should have been thrown as a null value has been given for the argument");
	     }
	     catch (BehaviourComposerApplicationException e)
	     {
	         assertTrue(true);
	     }
	     
	     //retrieve behaviourComposerAttachment by behaviourComposerAttachment id
	     try
	     {
	         behaviourComposerService.retrieveAttachment(null);
	         fail("An exception should have been thrown as a null value has been given for the argument");
	     }
	     catch (BehaviourComposerApplicationException e)
	     {
	         assertTrue(true);
	     }
	     
	     //retrieve behaviourComposerAttachment by uuid
	     try
	     {
	         behaviourComposerService.retrieveAttachmentByUuid(null);
	         fail("An exception should have been thrown as a null value has been given for the argument");
	     }
	     catch (BehaviourComposerApplicationException e)
	     {
	         assertTrue(true);
	     }
	     
	 }
	
	public void testSaveAttachment()
	{
	  /*  String newFilename = "BehaviourComposerInstructions.txt";
	    initBehaviourComposerAttachmentData();
	    
	    behaviourComposerAttachment = behaviourComposerService.retrieveAttachmentByUuid(TEST_UUID);
	    behaviourComposerAttachment.setFilename(newFilename);
	    
	    behaviourComposerService.saveAttachment(behaviourComposerAttachment);
	    
	    behaviourComposerAttachment = behaviourComposerService.retrieveAttachmentByUuid(TEST_UUID);
	    assertEquals(behaviourComposerAttachment.getFilename(), newFilename); */
	    String filename = "OnlineInstructions.txt";
	    boolean isOnline = true;
	    Long uuid = new Long(2);
	    
	    BehaviourComposerAttachment file = new BehaviourComposerAttachment();
	    behaviourComposerContent = behaviourComposerService.retrieveBehaviourComposer(TEST_NB_ID);
	    file.setBehaviourComposerContent(behaviourComposerContent);
	    file.setFilename(filename);
	    file.setOnlineFile(isOnline);
	    file.setUuid(uuid);
	    
	    behaviourComposerService.saveAttachment(behaviourComposerContent, file);
	    
	}
	
/* This method fails because the attachment isnt really uploaded to the content repository sow hen it tries to delete from repository it fails */
		
	/*public void testRemoveAttachment() 
	{
	    initBehaviourComposerAttachmentData();
	    behaviourComposerAttachment = behaviourComposerService.retrieveAttachmentByUuid(TEST_UUID);
	    
	    try {
			behaviourComposerService.removeAttachment(behaviourComposerService.retrieveBehaviourComposer(TEST_NB_ID), behaviourComposerAttachment);
		} catch (RepositoryCheckedException e) {
			fail("Repository exception thrown"+e.getMessage());
		}
	   
	    behaviourComposerAttachment = behaviourComposerService.retrieveAttachmentByUuid(TEST_UUID);
	    
	    assertNull(behaviourComposerAttachment);
	    
	} */
	
	/*public void testGetToolDefaultContentIdBySignature()
	{
	    Long defaultToolContentId = behaviourComposerService.getToolDefaultContentIdBySignature(BehaviourComposerConstants.TOOL_SIGNATURE);
	    assertNotNull(defaultToolContentId);
	} */
	
	public void testRetrieveBehaviourComposerUserBySession()
	{
		 Long newSessionId1 = new Long(3457);
		 BehaviourComposerSession newSession1 = new BehaviourComposerSession(newSessionId1);
	     behaviourComposerService.addSession(TEST_NB_ID, newSession1);
	     
	     BehaviourComposerUser oldUserInSession1 = new BehaviourComposerUser(TEST_USER_ID, newSession1);
	     behaviourComposerService.saveBehaviourComposerUser(oldUserInSession1);
	     
	     //associate the same test user to another new session
	     Long newSessionId2 = new Long(3458);
		 BehaviourComposerSession newSession2 = new BehaviourComposerSession(newSessionId2);
	     behaviourComposerService.addSession(TEST_NB_ID, newSession2);
	     
	     BehaviourComposerUser oldUserInSession2 = new BehaviourComposerUser(TEST_USER_ID, newSession2);
	     behaviourComposerService.saveBehaviourComposerUser(oldUserInSession2);
	     
	     //create another user in one of the existing sessions
	     Long newUserId = new Long(3459);
	     BehaviourComposerUser user2 = new BehaviourComposerUser(newUserId, newSession1);
	     behaviourComposerService.saveBehaviourComposerUser(user2);
	     
	     //try to get the test user using newSessionId1
	     behaviourComposerUser = behaviourComposerService.retrieveBehaviourComposerUserBySession(TEST_USER_ID, newSessionId1);
	     assertEquals(behaviourComposerUser.getUserId(), TEST_USER_ID);
	     assertEquals(behaviourComposerUser.getBehaviourComposerSession().getBehaviourComposerSessionId(), newSessionId1);
	     
	     //try to get the test user using newSessionId2
	     behaviourComposerUser = behaviourComposerService.retrieveBehaviourComposerUserBySession(TEST_USER_ID, newSessionId2);
	     assertEquals(behaviourComposerUser.getUserId(), TEST_USER_ID);
	     assertEquals(behaviourComposerUser.getBehaviourComposerSession().getBehaviourComposerSessionId(), newSessionId2);
	     
	     //try to get the new user that was created
	     behaviourComposerUser = behaviourComposerService.retrieveBehaviourComposerUserBySession(newUserId, newSessionId1);
	     assertEquals(behaviourComposerUser.getUserId(), newUserId);
	     assertEquals(behaviourComposerUser.getBehaviourComposerSession().getBehaviourComposerSessionId(), newSessionId1);
	     
	     //try to get data that does not exist, should return null
	     behaviourComposerUser = behaviourComposerService.retrieveBehaviourComposerUserBySession(newUserId, newSessionId2);
	     assertNull(behaviourComposerUser);
	     
	
	}
		
}
	
	
