<%@ include file="/includes/taglibs.jsp"%>

<c:set var="onlineExist" value="false" />
<c:set var="offlineExist" value="false" />
<c:forEach var="att" items="${requestScope.sessionMap.attachmentList}">
	<c:if test="${att.onlineFile}">
		<c:set var="onlineExist" value="true" />
	</c:if>
	<c:if test="${not att.onlineFile}">
		<c:set var="offlineExist" value="true" />
	</c:if>
</c:forEach>

<!-- Instructions Tab Content  -->
<table>
	<tr>
		<td>
			<div class="field-name" style="text-align: left;">
				<fmt:message key="instructions.onlineInstructions"></fmt:message>
			</div>
			<html:textarea property="onlineInstructions" rows="3" cols="80"></html:textarea>
		</td>
	</tr>

	<c:if test="${onlineExist == 'true'}">
		<tr>
			<td>
				<c:if test="${not empty requestScope.sessionMap.attachmentList}">
					<ul>
						<c:forEach var="attachment"
							items="${requestScope.sessionMap.attachmentList}">
							<c:if test="${attachment.onlineFile}">
								<li>
									${attachment.filename}
									<c:set var="viewURL">
										<html:rewrite
											page="/download/?uuid=${attachment.uuid}&amp;preferDownload=false" />
									</c:set>
									<a href="javascript:launchInstructionsPopup('${viewURL}');">
										<fmt:message key="link.view" /> </a> &behaviourComposersp;

									<c:set var="downloadURL">
										<html:rewrite
											page="/download/?uuid=${attachment.uuid}&amp;preferDownload=true" />
									</c:set>
									<a href="${downloadURL}"> <fmt:message key="link.download" />
									</a> &behaviourComposersp;

									<html:link
										href="javascript:deleteAttachment('Delete','${attachment.uuid}')">
										<fmt:message key="link.delete" />
									</html:link>
								</li>
							</c:if>
						</c:forEach>
					</ul>
				</c:if>
			</td>
		</tr>
	</c:if>

	<tr>
		<td>
			<div class="field-name" style="text-align: left;">
				<fmt:message key="instructions.uploadOnlineInstr" />
			</div>
		</td>
	</tr>
	<tr>
		<td>
			<html:file property="onlineFile" />
			<html:submit property="method" styleClass="button">
				<fmt:message key="button.upload" />
			</html:submit>
		</td>
	</tr>
</table>

<hr />

<table>
	<tr>
		<td>
			<div class="field-name-alternative-color" style="text-align: left;">
				<fmt:message key="instructions.offlineInstructions"></fmt:message>
			</div>
			<html:textarea property="offlineInstructions" rows="3" cols="80"></html:textarea>
		</td>
	</tr>

	<c:if test="${offlineExist == 'true'}">
		<tr>
			<td>
				<c:if test="${not empty requestScope.sessionMap.attachmentList}">
					<ul>
						<c:forEach var="attachment"
							items="${requestScope.sessionMap.attachmentList}">
							<c:if test="${not attachment.onlineFile}">
								<li>
									${attachment.filename}
									<c:set var="viewURL">
										<html:rewrite
											page="/download/?uuid=${attachment.uuid}&amp;preferDownload=false" />
									</c:set>
									<a href="javascript:launchInstructionsPopup('${viewURL}');">
										<fmt:message key="link.view" /> </a> &behaviourComposersp;

									<c:set var="downloadURL">
										<html:rewrite
											page="/download/?uuid=${attachment.uuid}&amp;preferDownload=true" />
									</c:set>
									<a href="${downloadURL}"> <fmt:message key="link.download" />
									</a> &behaviourComposersp;

									<html:link
										href="javascript:deleteAttachment('Delete','${attachment.uuid}')">
										<fmt:message key="link.delete" />
									</html:link>
								</li>
							</c:if>
						</c:forEach>
					</ul>
				</c:if>
			</td>
		</tr>
	</c:if>

	<tr>
		<td>
			<div class="field-name-alternative-color" style="text-align: left;">
				<fmt:message key="instructions.uploadOfflineInstr" />
			</div>
		</td>
	</tr>
	<tr>
		<td>
			<html:file property="offlineFile" />
			<html:submit property="method" styleClass="button">
				<fmt:message key="button.upload" />
			</html:submit>
		</td>
	</tr>
</table>
