/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging.editor.manifestview;

import org.jdom.Element;
import uk.ac.reload.editor.contentpackaging.xml.ContentPackage;
import uk.ac.reload.editor.datamodel.ElementBinding;
import uk.ac.reload.editor.gui.ElementEditor;
import uk.ac.reload.editor.gui.widgets.FileTextFieldWidget;
import uk.ac.reload.jdom.XMLDocumentListener;
import uk.ac.reload.jdom.XMLDocumentListenerEvent;
import uk.ac.reload.moonunit.SchemaDocument;
import uk.ac.reload.moonunit.schema.SchemaElement;

public class ManifestElementEditor
extends ElementEditor {
    private boolean isTitleValue;
    private Element _titleElement;

    public void setElementBinding(ElementBinding elementBinding) {
        if (this._elementBinding != null) {
            this._elementBinding.getSchemaDocument().removeXMLDocumentListener((XMLDocumentListener)this);
        }
        this._elementBinding = elementBinding;
        this._elementBinding.getSchemaDocument().addXMLDocumentListener((XMLDocumentListener)this);
        Element element = this._elementBinding.getElement();
        String name = element.getName();
        if (name.equals("organization") || name.equals("item")) {
            if (this._elementBinding.getSchemaDocument().isDocumentNamespace(element)) {
                this.isTitleValue = true;
                SchemaElement schemaElement = this._elementBinding.getSchemaElement();
                if (schemaElement != null) {
                    schemaElement = schemaElement.getChild("title");
                }
                this._titleElement = element.getChild("title", element.getNamespace());
                this.setupWidget(this._elementBinding.getSchemaDocument(), this._titleElement, schemaElement);
            }
        } else {
            this.isTitleValue = false;
            this.setupWidget(this._elementBinding.getSchemaDocument(), this._elementBinding.getElement(), this._elementBinding.getSchemaElement());
        }
    }

    protected void setupWidget(SchemaDocument doc, Element element, SchemaElement schemaElement) {
        super.setupWidget(doc, element, schemaElement);
        if (this.getWidget() != null && this.getWidget() instanceof FileTextFieldWidget && schemaElement.getName().equals("location") && doc instanceof ContentPackage) {
            ((FileTextFieldWidget)this.getWidget()).setRelativePath(((ContentPackage)doc).getProjectFolder());
        }
    }

    public void elementChanged(XMLDocumentListenerEvent event) {
        if (event.getSource() == this) {
            return;
        }
        if (this.isTitleValue && this._titleElement != null) {
            Element changed_element = event.getElement();
            if (this._titleElement == changed_element) {
                this.setText(this._titleElement);
            }
        } else {
            super.elementChanged(event);
        }
    }

    protected synchronized void fireElementChanged(String text) {
        if (this.isTitleValue) {
            Element element = this._elementBinding.getElement();
            if (text.equals("")) {
                if (this._titleElement != null) {
                    this._elementBinding.getSchemaDocument().removeElement((Object)this, this._titleElement);
                    this._titleElement = null;
                }
            } else {
                if (this._titleElement == null) {
                    this._titleElement = new Element("title", element.getNamespace());
                    this._elementBinding.getSchemaDocument().addElement((Object)this, element, this._titleElement, false);
                }
                this._titleElement.setText(text);
            }
            this._elementBinding.getSchemaDocument().changedElement((Object)this, element);
        } else {
            super.fireElementChanged(text);
        }
    }
}

